/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.review;

import de.retest.recheck.ui.review.ActionChangeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestChangeSet {
    private static final Logger logger = LoggerFactory.getLogger(TestChangeSet.class);
    private final ArrayList<ActionChangeSet> actionChangeSets;
    private ActionChangeSet initialStateChangeSet = new ActionChangeSet();

    TestChangeSet() {
        this.actionChangeSets = new ArrayList();
    }

    public ActionChangeSet createInitialActionChangeSet(String description, String stateFilePath) {
        this.initialStateChangeSet = new ActionChangeSet(description, stateFilePath);
        return this.initialStateChangeSet;
    }

    public ActionChangeSet createActionChangeSet() {
        return this.createActionChangeSet(null, null);
    }

    public ActionChangeSet createActionChangeSet(String description, String stateFilePath) {
        ActionChangeSet actionChangeSet = new ActionChangeSet(description, stateFilePath);
        this.actionChangeSets.add(actionChangeSet);
        return actionChangeSet;
    }

    public ActionChangeSet getInitialStateChangeSet() {
        return this.initialStateChangeSet;
    }

    public boolean containsInitialStateChangeSet() {
        return !this.initialStateChangeSet.isEmpty();
    }

    public ActionChangeSet getActionChangeSet(int index) {
        assert (index < this.actionChangeSets.size()) : "The given index should be smaller than the size of actionChangeSets!";
        if (index >= this.actionChangeSets.size()) {
            logger.error("The given index should be smaller than the size of actionChangeSets!");
            return null;
        }
        ActionChangeSet actionChangeSet = this.actionChangeSets.get(index);
        if (actionChangeSet == null || actionChangeSet.isEmpty()) {
            return null;
        }
        return actionChangeSet;
    }

    public boolean isEmpty() {
        return this.initialStateChangeSet.isEmpty() && TestChangeSet.isEmpty(this.actionChangeSets);
    }

    private static boolean isEmpty(ArrayList<ActionChangeSet> actionChangeSets) {
        for (ActionChangeSet actionChangeSet : actionChangeSets) {
            if (actionChangeSet.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<ActionChangeSet> getActionChangeSets() {
        return Collections.unmodifiableList(this.actionChangeSets);
    }
}

