/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ChecksumCalculator {
    public static final int LENGTH_OF_SHA256 = 64;
    private static ChecksumCalculator instance;

    public static ChecksumCalculator getInstance() {
        if (instance == null) {
            instance = new ChecksumCalculator();
        }
        return instance;
    }

    public String sha256(String input) {
        return this.getDigest("SHA-256", input.getBytes(StandardCharsets.UTF_8));
    }

    public String sha256(byte[] input) {
        return this.getDigest("SHA-256", input);
    }

    @Deprecated
    public String md5(String input) {
        return this.getDigest("MD5", input.getBytes(StandardCharsets.UTF_8));
    }

    @Deprecated
    public String md5(byte[] input) {
        return this.getDigest("MD5", input);
    }

    private String getDigest(String algorithm, byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hash = digest.digest(input);
            return this.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }
}

