/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import java.util.concurrent.TimeUnit;

public class DurationUtil {
    public static final String DURATION_DIFFERENCE_PROPERTY = "de.retest.difference.duration.value";
    public static final long DURATION_DIFFERENCE_DEFAULT = 1L;

    public static String durationToFormattedString(long duration) {
        long posDuration = duration < 0L ? -duration : duration;
        String sign = duration < 0L ? "-" : "";
        long millis = posDuration % 1000L;
        long secs = TimeUnit.MILLISECONDS.toSeconds(posDuration) % 60L;
        long mins = TimeUnit.MILLISECONDS.toMinutes(posDuration) % 60L;
        long hrs = TimeUnit.MILLISECONDS.toHours(posDuration);
        if (hrs > 0L) {
            return sign + String.format("%d:%02d:%02d h", hrs, mins, secs);
        }
        if (mins > 0L) {
            return sign + String.format("%d:%02d min", mins, secs);
        }
        return sign + String.format("%d.%03d s", secs, millis);
    }

    public static boolean ignore(long expected, long actual) {
        return DurationUtil.ignore(actual - expected);
    }

    public static boolean ignore(long duration) {
        return duration < TimeUnit.SECONDS.toMillis(Long.getLong(DURATION_DIFFERENCE_PROPERTY, 1L));
    }
}

