/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import de.retest.recheck.util.FileUtil;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class JvmUtil {
    static final String DEBUG_OPTION = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005";

    public static String getJvm() {
        String javaExecutable = SystemUtils.IS_OS_WINDOWS ? "javaw.exe" : "java";
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + javaExecutable + " ";
    }

    public static File getCurrentExecutionDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static String getCurrentClasspath() {
        StringBuilder builder = new StringBuilder();
        URLClassLoader urlClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        for (URL url : urlClassLoader.getURLs()) {
            File urlFile = new File(url.getFile());
            builder.append(FileUtil.canonicalPathQuietly(urlFile) + File.pathSeparator);
        }
        return builder.toString();
    }

    public static String toArg(Object key) {
        return "-D" + key;
    }

    public static String toArg(Object key, Object val) {
        return JvmUtil.toArg(key) + "=" + (StringUtils.containsWhitespace((CharSequence)val.toString()) ? "\"" + val + "\"" : val);
    }

    public static String evalToArg(Object key) {
        String val = System.getProperty(key.toString());
        return val != null ? JvmUtil.toArg(key, val) : null;
    }

    public static int getJvmPid() {
        return Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static List<String> getLaunchArguments() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    public static String findGuiJar() {
        Class<?> clazz;
        try {
            clazz = Class.forName("de.retest.cli.Retest");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        CodeSource source = clazz.getProtectionDomain().getCodeSource();
        if (source == null) {
            return null;
        }
        URL location = source.getLocation();
        if (location == null) {
            return null;
        }
        return FileUtils.toFile((URL)location).getAbsolutePath();
    }
}

