/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import de.retest.recheck.util.ListSet;
import de.retest.recheck.util.Mapping;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ListMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ArrayList<Mapping<K, V>> mappings = new ArrayList();

    public ListMap() {
    }

    public ListMap(Map<? extends K, ? extends V> otherMap) {
        this.putAll(otherMap);
    }

    @Override
    public int size() {
        return this.mappings.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    @Override
    public boolean containsKey(Object k1) {
        for (Mapping<K, V> mapping : this.mappings) {
            K k2 = mapping.getKey();
            if ((k1 != null || k2 != null) && (k2 == null || !k2.equals(k1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object v1) {
        for (Mapping<K, V> mapping : this.mappings) {
            V v2 = mapping.getValue();
            if ((v1 != null || v2 != null) && (v2 == null || !v2.equals(v1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object k1) {
        for (int idx = 0; idx < this.mappings.size(); ++idx) {
            K k2 = this.mappings.get(idx).getKey();
            if ((k1 != null || k2 != null) && (k2 == null || !k2.equals(k1))) continue;
            return this.mappings.get(idx).getValue();
        }
        return null;
    }

    @Override
    public V put(K k1, V value) {
        for (int idx = 0; idx < this.mappings.size(); ++idx) {
            K k2 = this.mappings.get(idx).getKey();
            if ((k1 != null || k2 != null) && (k2 == null || !k2.equals(k1))) continue;
            V result = this.mappings.get(idx).getValue();
            this.mappings.get(idx).setValue(value);
            return result;
        }
        this.mappings.add(new Mapping<K, V>(k1, value));
        return null;
    }

    @Override
    public V remove(Object k1) {
        for (int idx = 0; idx < this.mappings.size(); ++idx) {
            Mapping<K, V> mapping = this.mappings.get(idx);
            K k2 = mapping.getKey();
            if ((k1 != null || k2 != null) && (k2 == null || !k2.equals(k1))) continue;
            this.mappings.remove(idx);
            return mapping.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.mappings.clear();
    }

    @Override
    public Set<K> keySet() {
        ListSet<K> result = new ListSet<K>();
        for (Mapping<K, V> mapping : this.mappings) {
            result.add(mapping.getKey());
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        for (Mapping<K, V> mapping : this.mappings) {
            result.add(mapping.getValue());
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ListSet<Map.Entry<K, V>> result = new ListSet<Map.Entry<K, V>>();
        for (int idx = 0; idx < this.mappings.size(); ++idx) {
            Mapping<K, V> mapping = this.mappings.get(idx);
            result.add(new Mapping<K, V>(mapping.getKey(), mapping.getValue()));
        }
        return result;
    }
}

