/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ObjectUtil {
    private static final Pattern TOSTRING_OBJECT_ID_PATTERN = Pattern.compile("([\\.\\w]+@([0-9a-fA-F]{4,8}|1))");

    private ObjectUtil() {
    }

    public static <T> T checkNull(T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null!");
        }
        return object;
    }

    public static int compare(int previousResult, Serializable localAttr, Serializable otherAttr) {
        if (previousResult != 0) {
            return previousResult;
        }
        if (localAttr != null) {
            if (otherAttr != null) {
                return localAttr.toString().compareTo(otherAttr.toString());
            }
            return 1;
        }
        if (otherAttr != null) {
            return -1;
        }
        return 0;
    }

    public static int nextHashCode(int previousHash, Serializable attr) {
        if (attr == null) {
            return previousHash;
        }
        return previousHash + attr.hashCode() ^ 0x1F;
    }

    public static boolean isObjectToString(String text) {
        if (text == null) {
            return false;
        }
        Matcher matcher = TOSTRING_OBJECT_ID_PATTERN.matcher(text);
        return matcher.find();
    }

    public static String removeObjectHash(String text) {
        if (text == null) {
            return null;
        }
        if (ObjectUtil.isObjectToString(text)) {
            return text.substring(0, text.indexOf(64));
        }
        return text;
    }

    public static boolean isNullOrEmptyString(Object object) {
        return object == null || object instanceof CharSequence && StringUtils.isBlank((CharSequence)((CharSequence)object));
    }
}

