/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import de.retest.recheck.ui.descriptors.IdentifyingAttributes;

public class RetestIdUtil {
    private RetestIdUtil() {
    }

    public static String normalizeAndCut(String id) {
        return RetestIdUtil.cut(RetestIdUtil.normalize(id));
    }

    static String normalize(String id) {
        if (id == null || id.isEmpty()) {
            return "";
        }
        id = id.trim().replaceAll("[\\s]", "_");
        id = id.replaceAll("[^\\w]", "");
        while (id.contains("__")) {
            id = id.replaceAll("__", "_");
        }
        return id.toLowerCase();
    }

    static String cut(String id) {
        int nextBlank;
        if (id == null || id.isEmpty()) {
            return "";
        }
        if (id.length() <= 17) {
            return id;
        }
        int blank = id.indexOf(95);
        while (blank < 12 && (nextBlank = id.indexOf(95, blank + 1)) < 17 && nextBlank > -1) {
            blank = nextBlank;
        }
        if (blank >= 12 && blank <= 17) {
            return id.substring(0, blank);
        }
        return id.substring(0, 15);
    }

    public static boolean isValid(String retestId) {
        try {
            RetestIdUtil.validate(retestId, null);
            return true;
        }
        catch (InvalidRetestIdException e) {
            return false;
        }
    }

    public static void validate(String retestId, IdentifyingAttributes identifyingAttributes) throws InvalidRetestIdException {
        if (retestId == null) {
            throw new InvalidRetestIdException("retest ID must not be null for " + identifyingAttributes);
        }
        if (retestId.isEmpty()) {
            throw new InvalidRetestIdException("retest ID must not be empty for " + identifyingAttributes);
        }
        if (!retestId.matches("[\\w-_]+")) {
            throw new InvalidRetestIdException("retest ID must not contain any whitespaces or special characters for " + identifyingAttributes);
        }
    }

    public static String cutTypeQualifier(String type) {
        if (type == null) {
            return "";
        }
        return type.substring(type.lastIndexOf(46) + 1);
    }

    public static class InvalidRetestIdException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidRetestIdException(String message) {
            super(message);
        }
    }
}

