/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTraceParser {
    public static StackTraceElement[] parseStackTrace(String stackTrace) {
        Pattern headLinePattern = Pattern.compile("([\\w\\.]+)(:.*)?");
        Matcher headLineMatcher = headLinePattern.matcher(stackTrace);
        if (headLineMatcher.find()) {
            headLineMatcher.group(1);
            if (headLineMatcher.group(2) != null) {
                headLineMatcher.group(2);
            }
        }
        Pattern tracePattern = Pattern.compile("\\s*at\\s+([\\d\\w\\.$_]+)\\.([\\d\\w$_]+)\\((((.*java)?:(\\d+))|Native Method|Unknown Source)\\)(\\n|\\r\\n)?");
        Matcher traceMatcher = tracePattern.matcher(stackTrace);
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        while (traceMatcher.find()) {
            String className = traceMatcher.group(1);
            String methodName = traceMatcher.group(2);
            String sourceFile = traceMatcher.group(5);
            String lineNumString = traceMatcher.group(6);
            int lineNum = -1;
            if (lineNumString != null) {
                lineNum = Integer.parseInt(lineNumString);
            } else if (traceMatcher.group(3).equals("Native Method")) {
                lineNum = -2;
            }
            result.add(new StackTraceElement(className, methodName, sourceFile, lineNum));
        }
        return result.toArray(new StackTraceElement[result.size()]);
    }
}

