/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionProvider {
    private static final Logger logger = LoggerFactory.getLogger(VersionProvider.class);
    private static final String PROPERTIES_FILE_LOCATION = "/retest-defaults.properties";
    private static final String RETEST_VERSION_PROPERTY = "de.retest.version";
    public static final String RETEST_VERSION = VersionProvider.parseRetestVersion();
    public static final String RETEST_BUILD_DATE = VersionProvider.parseRetestBuildDate();

    private static String parseRetestVersion() {
        String packageVersion = VersionProvider.class.getPackage().getImplementationVersion();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{packageVersion})) {
            return packageVersion;
        }
        logger.warn("Failed to read package version!");
        String manifestVersion = VersionProvider.readVersionFromManifest();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{manifestVersion})) {
            return manifestVersion;
        }
        logger.warn("Failed to read manifest version!");
        String pomVersion = VersionProvider.readVersionFromProperties();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pomVersion})) {
            return pomVersion;
        }
        throw new RuntimeException("No version found. This seems to be a corrupted jar file: " + VersionProvider.getLocationOfClass());
    }

    private static String parseRetestBuildDate() {
        String manifestBuildDate = VersionProvider.readBuildDateFromManifest();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{manifestBuildDate})) {
            return manifestBuildDate;
        }
        return "Build date placeholder for running in IDE";
    }

    private static String readVersionFromManifest() {
        try {
            URLConnection jarConnection = VersionProvider.getLocationOfClass().openConnection();
            if (!(jarConnection instanceof JarURLConnection)) {
                return null;
            }
            JarURLConnection conn = (JarURLConnection)jarConnection;
            Manifest mf = conn.getManifest();
            Attributes atts = mf.getMainAttributes();
            return atts.getValue("Implementation-Version");
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String readVersionFromProperties() {
        Properties props = new Properties();
        try {
            props.load(VersionProvider.class.getResourceAsStream(PROPERTIES_FILE_LOCATION));
            return props.getProperty(RETEST_VERSION_PROPERTY);
        }
        catch (IOException e) {
            logger.error("Exception trying to read Maven version: ", (Throwable)e);
            return null;
        }
    }

    private static String readBuildDateFromManifest() {
        try {
            URLConnection jarConnection = VersionProvider.getLocationOfClass().openConnection();
            if (!(jarConnection instanceof JarURLConnection)) {
                return null;
            }
            JarURLConnection conn = (JarURLConnection)jarConnection;
            Manifest mf = conn.getManifest();
            Attributes atts = mf.getMainAttributes();
            return atts.getValue("Build-Time");
        }
        catch (IOException e) {
            return null;
        }
    }

    private static URL getLocationOfClass() {
        return VersionProvider.class.getResource(VersionProvider.class.getSimpleName() + ".class");
    }
}

