/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck;

import de.retest.recheck.printer.TestReplayResultPrinter;
import de.retest.recheck.report.TestReplayResult;
import java.io.File;
import java.util.stream.Collectors;

class RecheckCapMessage {
    private final String suiteName;
    private final TestReplayResult testReplayResult;
    private final TestReplayResultPrinter testReplayResultPrinter;
    private final File resultFile;

    public String toString() {
        return this.testReplayResult.hasNoGoldenMaster() ? this.getNoGoldenMasterErrorMessage() : this.getDifferencesErrorMessage();
    }

    private String getNoGoldenMasterErrorMessage() {
        String goldenMasterPath = this.testReplayResult.getActionReplayResults().stream().map(actionReplayResult -> "\t" + actionReplayResult.getGoldenMasterPath()).collect(Collectors.joining("\n"));
        return "'" + this.suiteName + "': " + "No Golden Master found. First time test was run? Created new Golden Master, so don't forget to commit..." + "\n" + goldenMasterPath;
    }

    private String getDifferencesErrorMessage() {
        int numChecks = this.testReplayResult.getActionReplayResults().size();
        String allDiffs = this.testReplayResultPrinter.toString(this.testReplayResult);
        String reportPath = this.resultFile.getAbsolutePath();
        return "A detailed report will be created at '" + reportPath + "'. You can review the details by using our CLI (https://github.com/retest/recheck.cli/) or GUI (https://retest.de/review/).\n\n" + numChecks + " check(s) in '" + this.suiteName + "' found the following difference(s):\n" + allDiffs;
    }

    public RecheckCapMessage(String suiteName, TestReplayResult testReplayResult, TestReplayResultPrinter testReplayResultPrinter, File resultFile) {
        this.suiteName = suiteName;
        this.testReplayResult = testReplayResult;
        this.testReplayResultPrinter = testReplayResultPrinter;
        this.resultFile = resultFile;
    }
}

