/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck;

import de.retest.recheck.NoGoldenMasterActionReplayResult;
import de.retest.recheck.Recheck;
import de.retest.recheck.RecheckAdapter;
import de.retest.recheck.RecheckCapMessage;
import de.retest.recheck.RecheckOptions;
import de.retest.recheck.Rehub;
import de.retest.recheck.SuiteAggregator;
import de.retest.recheck.SutStateLoader;
import de.retest.recheck.execution.RecheckAdapters;
import de.retest.recheck.execution.RecheckDifferenceFinder;
import de.retest.recheck.persistence.FileNamer;
import de.retest.recheck.persistence.RecheckSutState;
import de.retest.recheck.persistence.RecheckTestReportUtil;
import de.retest.recheck.printer.TestReplayResultPrinter;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.report.TestReplayResult;
import de.retest.recheck.report.TestReportFilter;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.diff.LeafDifference;
import de.retest.recheck.util.FileUtil;
import java.awt.HeadlessException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecheckImpl
implements Recheck,
SutStateLoader {
    private static final Logger logger = LoggerFactory.getLogger(RecheckImpl.class);
    private final CapWarner capWarner = new CapWarner();
    private final SuiteReplayResult suite;
    private final RecheckOptions options;
    private final String suiteName;
    private TestReplayResult currentTestResult;
    private final Map<String, DefaultValueFinder> usedFinders = new HashMap<String, DefaultValueFinder>();
    private final TestReplayResultPrinter printer = new TestReplayResultPrinter(this.usedFinders::get);

    public RecheckImpl() {
        this(RecheckOptions.builder().build());
    }

    public RecheckImpl(RecheckOptions options) {
        Runtime.getRuntime().addShutdownHook(this.capWarner);
        this.options = options;
        this.suiteName = options.getNamingStrategy().getSuiteName();
        this.suite = SuiteAggregator.getInstance().getSuite(this.suiteName, options.getProjectLayout().getTestSourcesRoot().orElse(null));
        if (options.isReportUploadEnabled()) {
            try {
                Rehub.authenticate();
            }
            catch (HeadlessException e) {
                throw new AssertionError((Object)"Please set a valid recheck API key within the environment, using 'RECHECK_API_KEY'.");
            }
        }
    }

    @Override
    public void startTest() {
        if (this.options.getFileNamerStrategy() != null) {
            this.startTest(this.options.getFileNamerStrategy().getTestMethodName());
        } else {
            this.startTest(this.options.getNamingStrategy().getTestName());
        }
    }

    @Override
    public void startTest(String testName) {
        this.currentTestResult = new TestReplayResult(testName, 0);
    }

    @Override
    public void check(Object toVerify, String currentStep) {
        this.check(toVerify, RecheckAdapters.findAdapterFor(toVerify, this.options), currentStep);
    }

    @Override
    public void check(Object toVerify, RecheckAdapter adapter, String currentStep) {
        if (this.currentTestResult == null) {
            logger.warn("Please call 'startTest()' before performing a check.");
            this.startTest();
        }
        ActionReplayResult actionReplayResult = this.createActionReplayResult(toVerify, adapter, currentStep);
        this.currentTestResult.addAction(actionReplayResult);
    }

    protected ActionReplayResult createActionReplayResult(Object toVerify, RecheckAdapter adapter, String currentStep) {
        DefaultValueFinder defaultFinder = this.getFinder(adapter, currentStep);
        File file = this.getGoldenMasterFile(currentStep);
        SutState actual = RecheckSutState.convert(toVerify, adapter);
        SutState expected = this.loadExpected(file);
        if (expected == null) {
            this.createNew(file, actual);
            return new NoGoldenMasterActionReplayResult(currentStep, actual, file.getPath());
        }
        RecheckDifferenceFinder finder = new RecheckDifferenceFinder(defaultFinder, currentStep, file.getPath());
        ActionReplayResult actionReplayResult = finder.findDifferences(expected, actual);
        if (actionReplayResult.hasDifferences()) {
            adapter.notifyAboutDifferences(actionReplayResult);
        }
        return actionReplayResult;
    }

    protected DefaultValueFinder getFinder(RecheckAdapter adapter, String currentStep) {
        DefaultValueFinder defaultFinder = adapter.getDefaultValueFinder();
        this.usedFinders.put(currentStep, defaultFinder);
        return defaultFinder;
    }

    protected File getGoldenMasterFile(String currentStep) {
        if (this.options.getFileNamerStrategy() != null) {
            String name = this.suiteName + File.separator + this.currentTestResult.getName() + "." + FileUtil.normalize(currentStep);
            FileNamer fileNamer = this.options.getFileNamerStrategy().createFileNamer(name);
            return fileNamer.getFile(".recheck");
        }
        return this.options.getProjectLayout().getGoldenMaster(this.suiteName, this.currentTestResult.getName(), FileUtil.normalize(currentStep)).toFile();
    }

    @Override
    public SutState loadExpected(File file) {
        return RecheckSutState.loadExpected(file);
    }

    @Override
    public SutState createNew(File file, SutState actual) {
        return RecheckSutState.createNew(file, actual);
    }

    protected TestReplayResult capTestSilently() {
        this.suite.addTest(this.currentTestResult);
        TestReportFilter testReportFilter = new TestReportFilter(this.options.getFilter());
        TestReplayResult filteredTestResult = testReportFilter.filter(this.currentTestResult);
        this.currentTestResult = null;
        return filteredTestResult;
    }

    @Override
    public void capTest() {
        TestReplayResult filteredTestResult = this.capTestSilently();
        Set<LeafDifference> uniqueDifferences = filteredTestResult.getDifferences();
        if (!uniqueDifferences.isEmpty()) {
            logger.warn("Found {} not ignored difference(s) in test '{}'.", (Object)uniqueDifferences.size(), (Object)filteredTestResult.getName());
            RecheckCapMessage msg = new RecheckCapMessage(this.suiteName, filteredTestResult, this.printer, this.getResultFile());
            throw new AssertionError(msg);
        }
    }

    @Override
    public void cap() {
        this.capWarner.disarm();
        try {
            if (this.currentTestResult != null) {
                logger.warn("Test {} was not finished. You should call 'capTest()' after your test, to have it fail on changes!", (Object)this.currentTestResult.getName());
                this.capTest();
            }
        }
        finally {
            File file = this.getResultFile();
            RecheckTestReportUtil.persist(this.suite, file);
        }
    }

    public File getResultFile() {
        if (this.options.getFileNamerStrategy() != null) {
            return this.options.getFileNamerStrategy().createFileNamer(this.suiteName).getResultFile(".report");
        }
        return this.options.getProjectLayout().getReport(this.suiteName).toFile();
    }

    private class CapWarner
    extends Thread {
        private volatile boolean armed = true;

        private CapWarner() {
        }

        @Override
        public void run() {
            if (!this.armed) {
                return;
            }
            if (RecheckImpl.this.currentTestResult != null) {
                logger.warn("Test {} was not finished!", (Object)RecheckImpl.this.currentTestResult.getName());
            }
            logger.warn("You should call 'cap()' after your test '{}' has finished, to persist test results.", (Object)RecheckImpl.this.suiteName);
        }

        public void disarm() {
            this.armed = false;
            Runtime.getRuntime().removeShutdownHook(this);
        }
    }
}

