/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck;

import de.retest.recheck.FileNamerStrategy;
import de.retest.recheck.RecheckProperties;
import de.retest.recheck.configuration.ProjectConfiguration;
import de.retest.recheck.ignore.CompoundFilter;
import de.retest.recheck.ignore.Filter;
import de.retest.recheck.ignore.RecheckIgnoreLocator;
import de.retest.recheck.ignore.SearchFilterFiles;
import de.retest.recheck.persistence.ClassAndMethodBasedNamingStrategy;
import de.retest.recheck.persistence.FileNamer;
import de.retest.recheck.persistence.NamingStrategy;
import de.retest.recheck.persistence.ProjectLayout;
import de.retest.recheck.persistence.ProjectLayouts;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.recheck.util.RetestIdProviderUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class RecheckOptions {
    private final FileNamerStrategy fileNamerStrategy;
    private final NamingStrategy namingStrategy;
    private final ProjectLayout projectLayout;
    private final boolean reportUploadEnabled;
    private final Filter filter;
    private final RetestIdProvider retestIdProvider;

    protected RecheckOptions(RecheckOptions toCopy) {
        this(toCopy.fileNamerStrategy, toCopy.namingStrategy, toCopy.projectLayout, toCopy.reportUploadEnabled, toCopy.filter, toCopy.retestIdProvider);
    }

    public static RecheckOptionsBuilder builder() {
        return new RecheckOptionsBuilder();
    }

    public FileNamerStrategy getFileNamerStrategy() {
        return this.fileNamerStrategy;
    }

    public boolean isReportUploadEnabled() {
        return this.reportUploadEnabled;
    }

    public RetestIdProvider getRetestIdProvider() {
        return this.retestIdProvider;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public ProjectLayout getProjectLayout() {
        return this.projectLayout;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    protected RecheckOptions(FileNamerStrategy fileNamerStrategy, NamingStrategy namingStrategy, ProjectLayout projectLayout, boolean reportUploadEnabled, Filter filter, RetestIdProvider retestIdProvider) {
        this.fileNamerStrategy = fileNamerStrategy;
        this.namingStrategy = namingStrategy;
        this.projectLayout = projectLayout;
        this.reportUploadEnabled = reportUploadEnabled;
        this.filter = filter;
        this.retestIdProvider = retestIdProvider;
    }

    private static final class FixedSuiteNamingStrategy
    implements NamingStrategy {
        private final String suiteName;
        private final NamingStrategy namingStrategy;

        @Override
        public String getSuiteName() {
            return this.suiteName;
        }

        @Override
        public String getTestName() {
            return this.namingStrategy.getTestName();
        }

        public FixedSuiteNamingStrategy(String suiteName, NamingStrategy namingStrategy) {
            this.suiteName = suiteName;
            this.namingStrategy = namingStrategy;
        }
    }

    public static class RecheckOptionsBuilder {
        private FileNamerStrategy fileNamerStrategy;
        private NamingStrategy namingStrategy = new ClassAndMethodBasedNamingStrategy();
        private ProjectLayout projectLayout;
        private String suiteName = null;
        private Boolean reportUploadEnabled;
        private Filter ignoreFilter = null;
        private RetestIdProvider retestIdProvider = RetestIdProviderUtil.getConfiguredRetestIdProvider();
        private final List<Filter> ignoreFilterToAdd = new ArrayList<Filter>();

        protected RecheckOptionsBuilder() {
        }

        @Deprecated
        public RecheckOptionsBuilder fileNamerStrategy(FileNamerStrategy fileNamerStrategy) {
            this.fileNamerStrategy = fileNamerStrategy;
            return this.namingStrategy(fileNamerStrategy);
        }

        public RecheckOptionsBuilder namingStrategy(NamingStrategy namingStrategy) {
            this.namingStrategy = namingStrategy;
            return this;
        }

        public RecheckOptionsBuilder projectLayout(ProjectLayout projectLayout) {
            this.projectLayout = projectLayout;
            return this;
        }

        public RecheckOptionsBuilder suiteName(String suiteName) {
            this.suiteName = suiteName;
            return this;
        }

        public RecheckOptionsBuilder enableReportUpload() {
            this.reportUploadEnabled = true;
            return this;
        }

        public RecheckOptionsBuilder disableReportUpload() {
            this.reportUploadEnabled = false;
            return this;
        }

        public RecheckOptionsBuilder setIgnore(String filterName) {
            this.ignoreFilter = SearchFilterFiles.getFilterByName(filterName);
            return this;
        }

        public RecheckOptionsBuilder ignoreNothing() {
            this.ignoreFilter = Filter.NEVER_MATCH;
            return this;
        }

        RecheckOptionsBuilder setIgnore(Filter filter) {
            this.ignoreFilter = filter;
            return this;
        }

        public RecheckOptionsBuilder addIgnore(String filterName) {
            if (this.ignoreFilter != null) {
                throw new IllegalStateException("Cannot combine `setIgnore( String )` and `addIgnore( String )`.");
            }
            this.ignoreFilterToAdd.add(SearchFilterFiles.getFilterByName(filterName));
            return this;
        }

        public RecheckOptionsBuilder retestIdProvider(RetestIdProvider retestIdProvider) {
            this.retestIdProvider = retestIdProvider;
            return this;
        }

        public RecheckOptions build() {
            ProjectConfiguration.getInstance().ensureProjectConfigurationInitialized();
            if (this.projectLayout == null) {
                this.projectLayout(ProjectLayouts.detect());
            }
            String suiteName = this.getSuiteName();
            FixedSuiteNamingStrategy namingStrategy = new FixedSuiteNamingStrategy(suiteName, this.namingStrategy);
            return new RecheckOptions(this.fileNamerStrategy, namingStrategy, this.projectLayout, this.reportUploadEnabled != null ? this.reportUploadEnabled.booleanValue() : RecheckProperties.getInstance().rehubReportUploadEnabled(), this.buildFilter(suiteName), this.retestIdProvider);
        }

        private String getSuiteName() {
            if (this.suiteName != null) {
                return this.suiteName;
            }
            return this.namingStrategy.getSuiteName();
        }

        private Filter buildFilter(String suiteName) {
            boolean addDefaultFilters;
            Filter filter = this.ignoreFilter != null ? this.ignoreFilter : new CompoundFilter(this.ignoreFilterToAdd);
            boolean bl = addDefaultFilters = this.ignoreFilter == null;
            if (!addDefaultFilters) {
                return filter;
            }
            return new CompoundFilter(filter, RecheckIgnoreLocator.loadRecheckIgnore(this.getSuitePath(suiteName)));
        }

        Path getSuitePath(String suiteName) {
            if (this.fileNamerStrategy != null) {
                FileNamer fileNamer = this.fileNamerStrategy.createFileNamer(suiteName);
                return fileNamer.getFile(".recheck").toPath();
            }
            return this.projectLayout.getSuiteFolder(suiteName);
        }
    }
}

