/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck;

import de.retest.recheck.configuration.ProjectRootFinderUtil;
import de.retest.recheck.persistence.FileOutputFormat;
import java.util.List;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigCache;
import org.aeonbits.owner.ConfigFactory;
import org.aeonbits.owner.Reloadable;

@Config.LoadPolicy(value=Config.LoadType.MERGE)
@Config.Sources(value={"system:properties", "system:env", "file:${projectroot}/.retest/retest.properties", "file:${user.home}/.retest/retest.properties"})
public interface RecheckProperties
extends Reloadable {
    public static final String PROPERTY_VALUE_SEPARATOR = ";";
    public static final String ZIP_FOLDER_SEPARATOR = "/";
    public static final String SCREENSHOT_FOLDER_NAME = "screenshot";
    public static final String RECHECK_FOLDER_NAME = "recheck";
    public static final String DEFAULT_XML_FILE_NAME = "retest.xml";
    public static final String RETEST_FOLDER_NAME = ".retest";
    public static final String GOLDEN_MASTER_FILE_EXTENSION = ".recheck";
    public static final String TEST_REPORT_FILE_EXTENSION = ".report";
    public static final String AGGREGATED_TEST_REPORT_FILE_NAME = "tests.report";
    public static final String IGNORE_ATTRIBUTES_PROPERTY_KEY = "de.retest.recheck.ignore.attributes";
    public static final String ELEMENT_MATCH_THRESHOLD_PROPERTY_KEY = "de.retest.recheck.elementMatchThreshold";
    public static final String ROOT_ELEMENT_MATCH_THRESHOLD_PROPERTY_KEY = "de.retest.recheck.rootElementMatchThreshold";
    public static final String ROOT_ELEMENT_CONTAINED_CHILDREN_MATCH_THRESHOLD_PROPERTY_KEY = "de.retest.recheck.rootElementContainedChildrenMatchThreshold";
    public static final String REHUB_REPORT_UPLOAD_ENABLED_PROPERTY_KEY = "de.retest.recheck.rehub.reportUploadEnabled";
    public static final String REHUB_REPORT_AUTH_URL_PROPERTY_KEY = "de.retest.recheck.rehub.authUrl";
    public static final String REHUB_REPORT_AUTH_KEY_PROPERTY_KEY = "de.retest.recheck.rehub.authKey";
    public static final String REHUB_REPORT_UPLOAD_URL_PROPERTY_KEY = "de.retest.recheck.rehub.reportUploadUrl";
    public static final String REHUB_REPORT_UPLOAD_ATTEMPTS = "de.retest.recheck.rehub.upload.attempts";
    public static final String FILE_OUTPUT_FORMAT_PROPERTY_KEY = "de.retest.output.Format";

    public static void init() {
        ProjectRootFinderUtil.getProjectRoot().ifPresent(projectRoot -> ConfigFactory.setProperty((String)"projectroot", (String)projectRoot.toAbsolutePath().toString()));
        ConfigCache.clear();
    }

    public static RecheckProperties getInstance() {
        RecheckProperties instance = (RecheckProperties)ConfigCache.getOrCreate(RecheckProperties.class, (Map[])new Map[0]);
        instance.reload();
        return instance;
    }

    @Config.Key(value="de.retest.recheck.ignore.attributes")
    @Config.DefaultValue(value="")
    @Config.Separator(value=";")
    public List<String> ignoreAttributes();

    @Config.Key(value="de.retest.recheck.elementMatchThreshold")
    @Config.DefaultValue(value="0.3")
    public double elementMatchThreshold();

    @Config.Key(value="de.retest.recheck.rootElementMatchThreshold")
    @Config.DefaultValue(value="0.5")
    public double rootElementMatchThreshold();

    @Config.Key(value="de.retest.recheck.rootElementContainedChildrenMatchThreshold")
    @Config.DefaultValue(value="0.5")
    public double rootElementContainedChildrenMatchThreshold();

    @Config.Key(value="de.retest.recheck.rehub.reportUploadEnabled")
    @Config.DefaultValue(value="false")
    public boolean rehubReportUploadEnabled();

    @Config.Key(value="de.retest.recheck.rehub.authUrl")
    @Config.DefaultValue(value="https://login.retest.de/auth/realms/customer/protocol/openid-connect")
    public String rehubReportAuthUrl();

    @Config.Key(value="de.retest.recheck.rehub.authKey")
    @Config.DefaultValue(value="tvrdxLHWA3h3SQRElQnGpKqxcCmMBpMSOhg4F7huUto")
    public String rehubAuthKey();

    @Config.Key(value="de.retest.recheck.rehub.reportUploadUrl")
    @Config.DefaultValue(value="https://artifact-storage-steward.prod.cloud.retest.org/api/v1/report")
    public String rehubReportUploadUrl();

    @Config.Key(value="de.retest.recheck.rehub.upload.attempts")
    @Config.DefaultValue(value="3")
    public int rehubReportUploadAttempts();

    @Config.Key(value="de.retest.output.Format")
    public FileOutputFormat fileOutputFormat();

    default public FileOutputFormat getReportOutputFormat() {
        if (this.rehubReportUploadEnabled()) {
            return FileOutputFormat.CLOUD;
        }
        FileOutputFormat format = this.fileOutputFormat();
        if (format == null) {
            return FileOutputFormat.KRYO;
        }
        return format;
    }

    default public FileOutputFormat getStateOutputFormat() {
        FileOutputFormat format = this.fileOutputFormat();
        return format == FileOutputFormat.ZIP ? format : FileOutputFormat.PLAIN;
    }
}

