/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck;

import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.report.TestReport;
import de.retest.recheck.suite.ExecutableSuite;
import de.retest.recheck.ui.actions.ActionStateSequence;
import de.retest.recheck.ui.descriptors.GroundState;
import java.nio.file.Path;
import java.util.ArrayList;

public class SuiteAggregator {
    private static SuiteAggregator instance;
    private final TestReport aggregatedTestReport = TestReport.fromApi();
    private SuiteReplayResult currentSuite;

    public static SuiteAggregator getInstance() {
        if (instance == null) {
            instance = new SuiteAggregator();
        }
        return instance;
    }

    public static void reset() {
        instance = null;
    }

    static SuiteAggregator getTestInstance() {
        return new SuiteAggregator();
    }

    private SuiteAggregator() {
    }

    public TestReport getAggregatedTestReport() {
        return this.aggregatedTestReport;
    }

    public SuiteReplayResult getSuite(String suiteName) {
        return this.getSuite(suiteName, null);
    }

    public SuiteReplayResult getSuite(String suiteName, Path testSourceRoot) {
        if (this.currentSuite == null) {
            this.currentSuite = this.createSuiteReplayResult(suiteName, testSourceRoot);
        }
        if (!suiteName.equals(this.currentSuite.getName())) {
            this.currentSuite = this.createSuiteReplayResult(suiteName, testSourceRoot);
        }
        return this.currentSuite;
    }

    private SuiteReplayResult createSuiteReplayResult(String suiteName, Path testSourceRoot) {
        GroundState groundState = new GroundState();
        ExecutableSuite execSuite = new ExecutableSuite(groundState, 0L, new ArrayList<ActionStateSequence>());
        execSuite.setName(suiteName);
        SuiteReplayResult suiteReplayResult = new SuiteReplayResult(suiteName, testSourceRoot, 0, groundState, execSuite.getUuid(), groundState);
        this.aggregatedTestReport.addSuite(suiteReplayResult);
        return suiteReplayResult;
    }
}

