/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck;

import de.retest.recheck.util.OptionalUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseFinder {
    private static final Logger log = LoggerFactory.getLogger(TestCaseFinder.class);
    public static final String DELIMITER = "_";
    static final TestCaseInformation NO_TEST_CASE_INFORMATION = new TestCaseInformation(null, TestCaseAnnotationType.NONE, 0);
    private static final Set<String> testCaseAnnotations = new HashSet<String>(Arrays.asList("org.junit.Test", "org.junit.Before", "org.junit.After", "org.junit.BeforeClass", "org.junit.AfterClass", "org.junit.jupiter.api.Test", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll", "org.testng.annotations.Test", "org.testng.annotations.BeforeMethod", "org.testng.annotations.AfterMethod", "org.testng.annotations.BeforeClass", "org.testng.annotations.AfterClass"));
    private static final Set<String> repeatableTestCaseAnnotations = new HashSet<String>(Arrays.asList("org.junit.experimental.theories.Theory", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.params.ParameterizedTest"));
    private static final List<String> suffixes = Arrays.asList("Test", "Tests", "TestCase", "IT", "ITCase");
    private static final List<String> prefixes = Arrays.asList("Test", "IT");
    private static TestCaseFinder instance;
    private final Map<StackTraceElement, Integer> repeatableTestCaseAnnotationsCount = new HashMap<StackTraceElement, Integer>();

    private static Function<TestCaseInformation, String> toClassName() {
        return info -> info.getStackTraceElement().getClassName();
    }

    private static Function<TestCaseInformation, String> toMethodName() {
        return info -> {
            String methodName = info.getStackTraceElement().getMethodName();
            return info.isRepeatable() ? methodName + DELIMITER + info.getInvocationCount() : methodName;
        };
    }

    private TestCaseFinder() {
    }

    public static TestCaseFinder getInstance() {
        if (instance == null) {
            instance = new TestCaseFinder();
        }
        return instance;
    }

    public Optional<String> findTestCaseMethodNameInStack() {
        return this.findTestCaseMethodInStack(TestCaseFinder.toMethodName());
    }

    public Optional<String> findTestCaseClassNameInStack() {
        Optional<String> testCaseClassName = this.findTestCaseMethodInStack(TestCaseFinder.toClassName());
        if (testCaseClassName.isPresent()) {
            return testCaseClassName;
        }
        return this.findTestCaseClassInStack();
    }

    public Optional<String> findTestCaseClassInStack() {
        return Thread.getAllStackTraces().values().stream().map(this::findTestCaseClassInStack).flatMap(OptionalUtil::stream).findFirst();
    }

    public Optional<String> findTestCaseClassInStack(StackTraceElement[] trace) {
        return Arrays.stream(trace).map(StackTraceElement::getClassName).filter(TestCaseFinder::isTestClass).findFirst();
    }

    private static boolean isTestClass(String className) {
        if (className.equals(TestCaseFinder.class.getName())) {
            return false;
        }
        String substringMarker = className.contains("$") ? "$" : ".";
        String simpleClassName = className.substring(className.lastIndexOf(substringMarker) + 1);
        for (String suffix : suffixes) {
            if (!simpleClassName.endsWith(suffix)) continue;
            return true;
        }
        for (String prefix : prefixes) {
            if (!simpleClassName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public Optional<String> findTestCaseMethodNameInStack(StackTraceElement[] trace) {
        return this.findTestCaseMethodInStack(TestCaseFinder.toMethodName(), trace);
    }

    public Optional<String> findTestCaseClassNameInStack(StackTraceElement[] trace) {
        return this.findTestCaseMethodInStack(TestCaseFinder.toClassName(), trace);
    }

    private Optional<String> findTestCaseMethodInStack(Function<TestCaseInformation, String> mapper) {
        TestCaseInformation info = this.findTestCaseMethodInStack();
        return info.isFound() ? Optional.of(mapper.apply(info)) : Optional.empty();
    }

    private Optional<String> findTestCaseMethodInStack(Function<TestCaseInformation, String> mapper, StackTraceElement[] trace) {
        TestCaseInformation info = this.findTestCaseMethodInStack(trace);
        return info.isFound() ? Optional.of(mapper.apply(info)) : Optional.empty();
    }

    public TestCaseInformation findTestCaseMethodInStack() {
        for (StackTraceElement[] stack : Thread.getAllStackTraces().values()) {
            TestCaseInformation info = this.findTestCaseMethodInStack(stack);
            if (!info.isFound()) continue;
            return info;
        }
        return NO_TEST_CASE_INFORMATION;
    }

    public TestCaseInformation findTestCaseMethodInStack(StackTraceElement[] trace) {
        for (StackTraceElement element : trace) {
            TestCaseAnnotationType type = this.determineTestCaseAnnotationType(element);
            if (type == TestCaseAnnotationType.NORMAL) {
                return new TestCaseInformation(element, type, 1);
            }
            if (type != TestCaseAnnotationType.REPEATABLE) continue;
            int count = this.repeatableTestCaseAnnotationsCount.merge(element, 1, Integer::sum);
            return new TestCaseInformation(element, type, count);
        }
        return NO_TEST_CASE_INFORMATION;
    }

    private TestCaseAnnotationType determineTestCaseAnnotationType(StackTraceElement element) {
        Annotation[] annotations;
        Method method = this.tryToFindMethodForStackTraceElement(element);
        if (method == null) {
            return TestCaseAnnotationType.NONE;
        }
        for (Annotation annotation : annotations = method.getAnnotations()) {
            String annotationName = annotation.annotationType().getName();
            if (testCaseAnnotations.contains(annotationName)) {
                return TestCaseAnnotationType.NORMAL;
            }
            if (!repeatableTestCaseAnnotations.contains(annotationName)) continue;
            return TestCaseAnnotationType.REPEATABLE;
        }
        return TestCaseAnnotationType.NONE;
    }

    private Method tryToFindMethodForStackTraceElement(StackTraceElement element) {
        Class<?> clazz;
        Method method = null;
        try {
            clazz = Class.forName(element.getClassName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            for (Method methodCandidate : clazz.getDeclaredMethods()) {
                if (!methodCandidate.getName().equals(element.getMethodName())) continue;
                if (method == null) {
                    method = methodCandidate;
                    continue;
                }
                return null;
            }
        }
        catch (NoClassDefFoundError e) {
            log.error("Could not analyze method due to NoClassDefFoundError: {}", (Object)e.getMessage());
        }
        return method;
    }

    public static enum TestCaseAnnotationType {
        NORMAL,
        REPEATABLE,
        NONE;

    }

    public static final class TestCaseInformation {
        private final StackTraceElement stackTraceElement;
        private final TestCaseAnnotationType testCaseAnnotationType;
        private final int invocationCount;

        public boolean isFound() {
            return this.stackTraceElement != null;
        }

        public boolean isRepeatable() {
            return this.testCaseAnnotationType == TestCaseAnnotationType.REPEATABLE;
        }

        public TestCaseInformation(StackTraceElement stackTraceElement, TestCaseAnnotationType testCaseAnnotationType, int invocationCount) {
            this.stackTraceElement = stackTraceElement;
            this.testCaseAnnotationType = testCaseAnnotationType;
            this.invocationCount = invocationCount;
        }

        public StackTraceElement getStackTraceElement() {
            return this.stackTraceElement;
        }

        public TestCaseAnnotationType getTestCaseAnnotationType() {
            return this.testCaseAnnotationType;
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestCaseInformation)) {
                return false;
            }
            TestCaseInformation other = (TestCaseInformation)o;
            if (this.getInvocationCount() != other.getInvocationCount()) {
                return false;
            }
            StackTraceElement this$stackTraceElement = this.getStackTraceElement();
            StackTraceElement other$stackTraceElement = other.getStackTraceElement();
            if (this$stackTraceElement == null ? other$stackTraceElement != null : !((Object)this$stackTraceElement).equals(other$stackTraceElement)) {
                return false;
            }
            TestCaseAnnotationType this$testCaseAnnotationType = this.getTestCaseAnnotationType();
            TestCaseAnnotationType other$testCaseAnnotationType = other.getTestCaseAnnotationType();
            return !(this$testCaseAnnotationType == null ? other$testCaseAnnotationType != null : !((Object)((Object)this$testCaseAnnotationType)).equals((Object)other$testCaseAnnotationType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getInvocationCount();
            StackTraceElement $stackTraceElement = this.getStackTraceElement();
            result = result * 59 + ($stackTraceElement == null ? 43 : ((Object)$stackTraceElement).hashCode());
            TestCaseAnnotationType $testCaseAnnotationType = this.getTestCaseAnnotationType();
            result = result * 59 + ($testCaseAnnotationType == null ? 43 : ((Object)((Object)$testCaseAnnotationType)).hashCode());
            return result;
        }

        public String toString() {
            return "TestCaseFinder.TestCaseInformation(stackTraceElement=" + this.getStackTraceElement() + ", testCaseAnnotationType=" + (Object)((Object)this.getTestCaseAnnotationType()) + ", invocationCount=" + this.getInvocationCount() + ")";
        }
    }
}

