/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.auth;

import de.retest.recheck.Rehub;
import de.retest.recheck.auth.AuthenticationHandler;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RehubAuthenticationHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(RehubAuthenticationHandler.class);

    @Override
    public void showWebLoginUri(URI loginUri) {
        try {
            Desktop.getDesktop().browse(loginUri);
        }
        catch (IOException e) {
            log.error("Error opening browser for '{}'.", (Object)loginUri);
        }
    }

    @Override
    public void loginPerformed(String token) {
        log.info("Login successful.");
        log.info("Please use this token for your CI: {}", (Object)token);
        Preferences.userNodeForPackage(Rehub.class).put("RECHECK_API_KEY", token);
    }

    @Override
    public void loginFailed(Throwable reason) {
        log.error("Login failed: ", reason);
    }

    @Override
    public String getOfflineToken() {
        String tokenFromEnvironment = System.getenv("RECHECK_API_KEY");
        String tokenFromPreferences = Preferences.userNodeForPackage(Rehub.class).get("RECHECK_API_KEY", null);
        return tokenFromEnvironment != null ? tokenFromEnvironment : tokenFromPreferences;
    }

    @Override
    public void logoutPerformed() {
        Preferences.userNodeForPackage(Rehub.class).remove("RECHECK_API_KEY");
        log.info("Logout successful.");
    }

    @Override
    public void logoutFailed(Throwable reason) {
        log.error("Logout failed:", reason);
    }
}

