/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.auth;

import com.auth0.jwk.JwkException;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.JWTVerifier;
import de.retest.recheck.RecheckProperties;
import de.retest.recheck.auth.AuthenticationHandler;
import de.retest.recheck.auth.KeycloakResult;
import de.retest.recheck.auth.UnableToAuthenticateOfflineException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetestAuthentication {
    private static final Logger log = LoggerFactory.getLogger(RetestAuthentication.class);
    private static final String BASE_URL = RecheckProperties.getInstance().rehubReportAuthUrl();
    private static final String AUTH_URL = BASE_URL + "/auth";
    private static final String TOKEN_URL = BASE_URL + "/token";
    private static final String CERTS_URL = BASE_URL + "/certs";
    private static final String LOGOUT_URL = BASE_URL + "/logout";
    private static final String OAUTH_ACCESS_TOKEN = "access_token";
    private static final String OAUTH_REFRESH_TOKEN = "refresh_token";
    private static final String OAUTH_GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    private static final String OAUTH_GRANT_TYPE = "grant_type";
    private static final String OAUTH_SCOPE_OFFLINE_ACCESS = "offline_access";
    private static final String OAUTH_SCOPE = "scope";
    private static final String OAUTH_STATE = "state";
    private static final String OAUTH_REDIRECT_URI = "redirect_uri";
    private static final String OAUTH_CLIENT_ID = "client_id";
    private static final String OAUTH_RESPONSE_TYPE_CODE = "code";
    private static final String OAUTH_RESPONSE_TYPE = "response_type";
    private DecodedJWT accessToken;
    private final AuthenticationHandler handler;
    private final String client;
    private final JWTVerifier verifier;

    public RetestAuthentication(AuthenticationHandler handler, String client) {
        this.handler = handler;
        this.client = client;
        this.verifier = this.getJwtVerifier();
    }

    private JWTVerifier getJwtVerifier() {
        try {
            UrlJwkProvider provider = new UrlJwkProvider(URI.create(CERTS_URL).toURL());
            PublicKey publicKey = provider.get(RecheckProperties.getInstance().rehubAuthKey()).getPublicKey();
            return JWT.require((Algorithm)Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null)).acceptLeeway(3L).build();
        }
        catch (SigningKeyNotFoundException e) {
            UnableToAuthenticateOfflineException offline = new UnableToAuthenticateOfflineException(e);
            log.error("Exception retrieving signing key: ", (Throwable)offline);
            this.handler.loginFailed(offline);
            throw offline;
        }
        catch (JwkException | MalformedURLException e) {
            throw new RuntimeException("Error accessing keycloak JWK information", e);
        }
    }

    public void authenticate() {
        if (this.handler.getOfflineToken() != null) {
            this.refreshTokens();
        } else {
            log.info("No active token found, initiating authentication");
            this.login();
        }
    }

    private void login() {
        try {
            CallbackListener callback = new CallbackListener();
            callback.start();
            String redirectUri = "http://localhost:" + callback.server.getLocalPort();
            String state = UUID.randomUUID().toString();
            URIBuilder builder = new URIBuilder(AUTH_URL);
            builder.addParameter(OAUTH_RESPONSE_TYPE, OAUTH_RESPONSE_TYPE_CODE);
            builder.addParameter(OAUTH_CLIENT_ID, this.client);
            builder.addParameter(OAUTH_REDIRECT_URI, redirectUri);
            builder.addParameter(OAUTH_STATE, state);
            builder.addParameter(OAUTH_SCOPE, OAUTH_SCOPE_OFFLINE_ACCESS);
            URI loginUri = URI.create(builder.build().toString());
            log.info("Show web login: {}", (Object)loginUri);
            this.handler.showWebLoginUri(loginUri);
            callback.join();
            log.info("Web login performed.");
            if (this.loginSuccessful(state, callback.result)) {
                TokenBundle bundle = this.accessCodeToToken(callback.result.getCode(), redirectUri);
                this.accessToken = this.verifier.verify(bundle.accessToken);
                this.handler.loginPerformed(bundle.refreshToken);
            } else {
                this.handler.loginFailed(this.retrieveError(callback.result));
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            log.error("Error during authentication", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private Throwable retrieveError(KeycloakResult result) {
        IOException exception = result.getErrorException();
        String error = result.getError();
        if (exception != null) {
            return exception;
        }
        if (!StringUtils.isEmpty((CharSequence)error)) {
            return new RuntimeException(error);
        }
        return new RuntimeException("Error during login");
    }

    private boolean loginSuccessful(String state, KeycloakResult result) {
        return state.equals(result.getState()) && result.getError() == null && result.getErrorException() == null;
    }

    private TokenBundle accessCodeToToken(String code, String redirectUri) {
        TokenBundle bundle = new TokenBundle();
        HttpResponse response = Unirest.post((String)TOKEN_URL).field(OAUTH_GRANT_TYPE, (Object)OAUTH_GRANT_TYPE_AUTHORIZATION_CODE).field(OAUTH_RESPONSE_TYPE_CODE, code).field(OAUTH_CLIENT_ID, this.client).field(OAUTH_REDIRECT_URI, redirectUri).asJson();
        if (response.isSuccess()) {
            JSONObject object = ((JsonNode)response.getBody()).getObject();
            bundle.setAccessToken(object.getString(OAUTH_ACCESS_TOKEN));
            bundle.setRefreshToken(object.getString(OAUTH_REFRESH_TOKEN));
        } else {
            log.error("Auth token url call failed with {} {}: {}", new Object[]{response.getStatus(), response.getStatusText(), response.getBody()});
        }
        return bundle;
    }

    public void logout() {
        String offlineToken = this.handler.getOfflineToken();
        if (offlineToken != null) {
            HttpResponse response = Unirest.post((String)LOGOUT_URL).field(OAUTH_REFRESH_TOKEN, (Object)this.handler.getOfflineToken()).field(OAUTH_CLIENT_ID, this.client).asJson();
            if (response.isSuccess()) {
                this.handler.logoutPerformed();
            } else {
                this.handler.logoutFailed(new RuntimeException(response.getStatusText()));
            }
        } else {
            log.error("No offline token provided");
        }
    }

    private void refreshTokens() {
        Optional<DecodedJWT> refreshedToken = this.refreshAccessToken();
        if (refreshedToken.isPresent()) {
            this.accessToken = refreshedToken.get();
        } else {
            this.login();
        }
    }

    public DecodedJWT getAccessToken() {
        if (!this.isAccessTokenValid()) {
            this.refreshTokens();
        }
        return this.accessToken;
    }

    private Optional<DecodedJWT> refreshAccessToken() {
        HttpResponse response = Unirest.post((String)TOKEN_URL).field(OAUTH_GRANT_TYPE, (Object)OAUTH_REFRESH_TOKEN).field(OAUTH_REFRESH_TOKEN, this.handler.getOfflineToken()).field(OAUTH_CLIENT_ID, this.client).asJson();
        if (response.isSuccess()) {
            JSONObject object = ((JsonNode)response.getBody()).getObject();
            try {
                return Optional.of(this.verifier.verify(object.getString(OAUTH_ACCESS_TOKEN)));
            }
            catch (Exception e) {
                log.error("Error verifying access token: {}", (Object)e.getMessage());
                log.debug("Details: ", (Throwable)e);
            }
        }
        log.error("Error retrieving access token: {}", (Object)response.getStatusText());
        return Optional.empty();
    }

    private boolean isAccessTokenValid() {
        try {
            DecodedJWT verify = this.verifier.verify(this.accessToken);
            return this.accessToken != null && verify != null;
        }
        catch (JWTVerificationException exception) {
            log.info("Current token is invalid, requesting new one");
            return false;
        }
    }

    static KeycloakResult getRequestParameters(String request) {
        String url = "http://localhost/" + request.split(" ")[1];
        Map<String, String> parameters = URLEncodedUtils.parse((URI)URI.create(url), (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
        return KeycloakResult.builder().code(parameters.get(OAUTH_RESPONSE_TYPE_CODE)).error(parameters.get("error")).errorDescription(parameters.get("error-description")).state(parameters.get(OAUTH_STATE)).build();
    }

    private static class CallbackListener
    extends Thread {
        private final ServerSocket server = new ServerSocket(0);
        private KeycloakResult result;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (Socket socket = this.server.accept();){
                BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                try {
                    String request = br.readLine();
                    this.result = RetestAuthentication.getRequestParameters(request);
                    OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream());
                    try {
                        PrintWriter writer = new PrintWriter(out);
                        try {
                            if (this.result.getError() == null) {
                                writer.println("HTTP/1.1 302 Found");
                                writer.println("Location: " + TOKEN_URL.replace("/token", "/delegated"));
                            } else {
                                writer.println("HTTP/1.1 302 Found");
                                writer.println("Location: " + TOKEN_URL.replace("/token", "/delegated?error=true"));
                            }
                        }
                        finally {
                            if (Collections.singletonList(writer).get(0) != null) {
                                writer.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(out).get(0) != null) {
                            out.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(br).get(0) != null) {
                        br.close();
                    }
                }
            }
            catch (IOException e) {
                log.error("Error during communication with {}", (Object)BASE_URL, (Object)e);
            }
        }
    }

    private static class TokenBundle {
        private String accessToken;
        private String refreshToken;

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenBundle)) {
                return false;
            }
            TokenBundle other = (TokenBundle)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            String this$refreshToken = this.getRefreshToken();
            String other$refreshToken = other.getRefreshToken();
            return !(this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TokenBundle;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            String $refreshToken = this.getRefreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            return result;
        }

        public String toString() {
            return "RetestAuthentication.TokenBundle(accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ")";
        }
    }
}

