/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.configuration;

import de.retest.recheck.configuration.ProjectRootFinder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathBasedProjectRootFinder
implements ProjectRootFinder {
    private static final Logger logger = LoggerFactory.getLogger(PathBasedProjectRootFinder.class);
    private final Set<Path> indicators = new HashSet<Path>();

    public PathBasedProjectRootFinder() {
        this.indicators.add(Paths.get(".retest", new String[0]));
        this.indicators.add(Paths.get("src/main/java", new String[0]));
        this.indicators.add(Paths.get("src/test/java", new String[0]));
    }

    @Override
    public Optional<Path> findProjectRoot(Path base) {
        if (base == null || !base.toAbsolutePath().toFile().exists()) {
            logger.error("Project root not found, base path does not exist.");
            return Optional.empty();
        }
        Path absoluteBasePath = base.toAbsolutePath();
        logger.debug("Searching for project root under '{}'.", (Object)absoluteBasePath);
        for (Path currentFolder = absoluteBasePath; currentFolder != null; currentFolder = currentFolder.getParent()) {
            if (!this.containsSubPath(currentFolder)) continue;
            logger.debug("Found project root in '{}'.", (Object)currentFolder);
            return Optional.of(currentFolder.toAbsolutePath());
        }
        logger.error("Project root not found in {} or any parent folder.", (Object)absoluteBasePath);
        return Optional.empty();
    }

    private boolean containsSubPath(Path basePath) {
        if (basePath != null) {
            return this.indicators.stream().anyMatch(subPath -> basePath.resolve((Path)subPath).toFile().exists());
        }
        return false;
    }
}

