/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.configuration;

import de.retest.recheck.RecheckProperties;
import de.retest.recheck.configuration.ProjectRootFinderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ProjectConfiguration.class);
    public static final String RETEST_PROJECT_PROPERTIES = "retest.properties";
    public static final String RECHECK_IGNORE = "recheck.ignore";
    public static final String RECHECK_IGNORE_JSRULES = "recheck.ignore.js";
    private static final String DEFAULT_PREFIX = "default-";
    private static final String RETEST_PROJECT_DEFAULTS = "default-retest.properties";
    private static final String RECHECK_IGNORE_DEFAULTS = "default-recheck.ignore";
    private static final String RECHECK_IGNORE_JSRULES_DEFAULTS = "default-recheck.ignore.js";
    private static ProjectConfiguration instance;
    public static final String RETEST_PROJECT_ROOT = "de.retest.recheck.project.root";

    private ProjectConfiguration() {
    }

    public static ProjectConfiguration getInstance() {
        if (instance == null) {
            instance = new ProjectConfiguration();
        }
        return instance;
    }

    public Optional<Path> getProjectConfigFolder() {
        return ProjectRootFinderUtil.getProjectRoot().map(path -> path.resolve(".retest"));
    }

    public Path findProjectConfigFolder() {
        String msg = String.format("Project root could not be found. Please set the property '%s' to point to the project root (containing e.g. the %s folder).", RETEST_PROJECT_ROOT, ".retest");
        return this.getProjectConfigFolder().orElseThrow(() -> new RuntimeException(msg));
    }

    public void ensureProjectConfigurationInitialized() {
        Path projectRoot = this.findProjectConfigFolder();
        Path projectFilterFolder = projectRoot.resolve("filter");
        Path projectConfigFile = projectRoot.resolve(RETEST_PROJECT_PROPERTIES);
        Path projectIgnoreFile = projectRoot.resolve(RECHECK_IGNORE);
        Path projectRuleIgnoreFile = projectRoot.resolve(RECHECK_IGNORE_JSRULES);
        this.createProjectConfigurationFolderIfNeeded(projectRoot);
        this.createEmptyProjectConfigurationIfNeeded(projectConfigFile, RETEST_PROJECT_DEFAULTS);
        this.createEmptyProjectConfigurationIfNeeded(projectIgnoreFile, RECHECK_IGNORE_DEFAULTS);
        this.createEmptyProjectConfigurationIfNeeded(projectRuleIgnoreFile, RECHECK_IGNORE_JSRULES_DEFAULTS);
        this.createEmptyFolderIfNeeded(projectFilterFolder);
        RecheckProperties.init();
    }

    private void createProjectConfigurationFolderIfNeeded(Path configFolder) {
        if (!configFolder.toFile().exists()) {
            try {
                Files.createDirectories(configFolder, new FileAttribute[0]);
                Files.copy(this.getClass().getClassLoader().getResourceAsStream(RETEST_PROJECT_DEFAULTS), configFolder.resolve(RETEST_PROJECT_PROPERTIES), new CopyOption[0]);
                logger.info("Creating empty project configuration in {}.", (Object)configFolder);
            }
            catch (IOException e) {
                logger.error("Error creating project configuration folder in {}.", (Object)configFolder);
            }
        }
    }

    private void createEmptyProjectConfigurationIfNeeded(Path configFile, String defaultFile) {
        if (!configFile.toFile().exists()) {
            try (InputStream is = this.getInputStreamFrom(defaultFile);){
                Files.copy(is, configFile, new CopyOption[0]);
                logger.info("Creating empty recheck configuration in {}.", (Object)configFile);
            }
            catch (IOException e) {
                logger.error("Error creating empty recheck configuration in {}.", (Object)configFile);
            }
        }
    }

    private void createEmptyFolderIfNeeded(Path configFolder) {
        if (!configFolder.toFile().exists()) {
            try {
                Files.createDirectories(configFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("Error creating empty filter folder in {}.", (Object)configFolder);
            }
        }
    }

    private InputStream getInputStreamFrom(String fileName) {
        return this.getClass().getClassLoader().getResourceAsStream(fileName);
    }
}

