/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.execution;

import de.retest.recheck.RecheckAdapter;
import de.retest.recheck.RecheckOptions;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class RecheckAdapters {
    private static final ServiceLoader<RecheckAdapter> adapters = ServiceLoader.load(RecheckAdapter.class);

    private RecheckAdapters() {
    }

    public static RecheckAdapter findAdapterFor(Object toVerify, RecheckOptions options) {
        return StreamSupport.stream(adapters.spliterator(), false).filter(adapter -> adapter.canCheck(toVerify)).findAny().orElseThrow(() -> RecheckAdapters.createHelpfulExceptionForMissingAdapter(toVerify.getClass().getName())).initialize(options);
    }

    static UnsupportedOperationException createHelpfulExceptionForMissingAdapter(String className) {
        String msg = String.format("No recheck adapter registered that can handle an object of class %s.", className);
        if (className.startsWith("org.openqa.selenium")) {
            return new UnsupportedOperationException(msg + "\n You need to add recheck-web (https://github.com/retest/recheck-web) to the classpath.");
        }
        return new UnsupportedOperationException(msg);
    }
}

