/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.execution;

import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.action.ActionReplayData;
import de.retest.recheck.report.action.DifferenceRetriever;
import de.retest.recheck.report.action.WindowRetriever;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.diff.RootElementDifference;
import de.retest.recheck.ui.diff.RootElementDifferenceFinder;
import de.retest.recheck.ui.diff.StateDifference;
import de.retest.recheck.ui.diff.meta.MetadataDifference;
import de.retest.recheck.ui.diff.meta.MetadataDifferenceFinder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecheckDifferenceFinder {
    private static final Logger logger = LoggerFactory.getLogger(RecheckDifferenceFinder.class);
    private final RootElementDifferenceFinder finder;
    private final MetadataDifferenceFinder metadataDifferenceFinder = new MetadataDifferenceFinder();
    private final String currentStep;
    private final String goldenMasterPath;

    public RecheckDifferenceFinder(DefaultValueFinder finder, String currentStep, String goldenMasterPath) {
        this.finder = new RootElementDifferenceFinder(finder);
        this.currentStep = currentStep;
        this.goldenMasterPath = goldenMasterPath;
    }

    public ActionReplayResult findDifferences(SutState expected, SutState actual) {
        List<RootElementDifference> differences = this.finder.findDifferences(expected.getRootElements(), actual.getRootElements());
        MetadataDifference metadataDifference = this.metadataDifferenceFinder.findDifferences(expected, actual);
        if (!differences.isEmpty()) {
            return this.createResult(new StateDifference(differences), metadataDifference);
        }
        return this.createEmptyResult(actual, metadataDifference);
    }

    private ActionReplayResult createResult(StateDifference stateDifference, MetadataDifference metadataDifference) {
        logger.debug("Found {} differences for step '{}'.", (Object)stateDifference.size(), (Object)this.currentStep);
        return ActionReplayResult.withDifference(ActionReplayData.withoutTarget(this.currentStep, this.goldenMasterPath), WindowRetriever.empty(), DifferenceRetriever.of(stateDifference, metadataDifference), 0L);
    }

    private ActionReplayResult createEmptyResult(SutState actual, MetadataDifference metadataDifference) {
        logger.debug("Found no differences in step '{}'.", (Object)this.currentStep);
        return ActionReplayResult.withDifference(ActionReplayData.withoutTarget(this.currentStep, this.goldenMasterPath), WindowRetriever.of(actual), DifferenceRetriever.of(metadataDifference), 0L);
    }
}

