/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.io.Loader;
import de.retest.recheck.review.ignore.io.Loaders;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AllMatchFilter
implements Filter {
    private final List<Filter> filters;

    public AllMatchFilter(Filter ... filters) {
        this(Arrays.asList(filters));
    }

    public AllMatchFilter(List<Filter> filters) {
        this.filters = filters;
        if (filters.isEmpty()) {
            throw new IllegalArgumentException("Given filters must not be empty, please use Filter.ALWAYS_MATCH or Filter.NEVER_MATCH.");
        }
    }

    @Override
    public boolean matches(Element element) {
        return this.filters.stream().allMatch(f -> f.matches(element));
    }

    @Override
    public boolean matches(Element element, Filter.ChangeType change) {
        return this.filters.stream().allMatch(f -> f.matches(element, change));
    }

    @Override
    public boolean matches(Element element, AttributeDifference attributeDifference) {
        return this.filters.stream().allMatch(f -> f.matches(element, attributeDifference));
    }

    @Override
    public boolean matches(Element element, String attributeKey) {
        return this.filters.stream().allMatch(f -> f.matches(element, attributeKey));
    }

    public String toString() {
        return "AllMatchFilter(filters=" + this.getFilters() + ")";
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public static class AllMatchFilterLoader
    implements Loader<AllMatchFilter> {
        @Override
        public Optional<AllMatchFilter> load(String line) {
            return Optional.empty();
        }

        @Override
        public String save(AllMatchFilter ignore) {
            return ignore.filters.stream().map(f -> Loaders.filter().save((Filter)f)).collect(Collectors.joining(", "));
        }
    }
}

