/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.review.ignore.io.Loader;
import de.retest.recheck.review.ignore.io.Loaders;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;

public class CacheFilter
implements Filter {
    private final Map<Element, Boolean> elementCache = new HashMap<Element, Boolean>();
    private final Map<Pair<Element, AttributeDifference>, Boolean> attributeCache = new HashMap<Pair<Element, AttributeDifference>, Boolean>();
    private final Map<Pair<Element, String>, Boolean> attributeKeyCache = new HashMap<Pair<Element, String>, Boolean>();
    private final Filter base;

    @Override
    public boolean matches(Element element) {
        return this.elementCache.computeIfAbsent(element, this.matches());
    }

    private Function<Element, Boolean> matches() {
        return this.base::matches;
    }

    @Override
    public boolean matches(Element element, Filter.ChangeType changeType) {
        return this.elementCache.computeIfAbsent(element, e -> this.base.matches((Element)e, changeType));
    }

    @Override
    public boolean matches(Element element, AttributeDifference attributeDifference) {
        return this.attributeCache.computeIfAbsent((Pair<Element, AttributeDifference>)Pair.of((Object)element, (Object)attributeDifference), this.matchesDiff());
    }

    private Function<Pair<Element, AttributeDifference>, Boolean> matchesDiff() {
        return p -> this.base.matches((Element)p.getLeft(), (AttributeDifference)p.getRight());
    }

    @Override
    public boolean matches(Element element, String attributeKey) {
        return this.attributeKeyCache.computeIfAbsent((Pair<Element, String>)Pair.of((Object)element, (Object)attributeKey), this.matchesKeyDiff());
    }

    private Function<Pair<Element, String>, Boolean> matchesKeyDiff() {
        return p -> this.base.matches((Element)p.getLeft(), (String)p.getRight());
    }

    public CacheFilter(Filter base) {
        this.base = base;
    }

    public Filter getBase() {
        return this.base;
    }

    public static class FilterLoader
    implements Loader<CacheFilter> {
        @Override
        public Optional<CacheFilter> load(String line) {
            return Optional.empty();
        }

        @Override
        public String save(CacheFilter ignore) {
            return Loaders.filter().save(ignore.base);
        }
    }
}

