/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.util.Predicates;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CompoundFilter
implements Filter {
    private final List<Filter> filters;

    public CompoundFilter() {
        this(Collections.emptyList());
    }

    public CompoundFilter(Filter ... filters) {
        this(Arrays.asList(filters));
    }

    public CompoundFilter(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public boolean matches(Element element) {
        for (Filter filter : this.filters) {
            if (!filter.matches(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Element element, Filter.ChangeType change) {
        return this.filters.stream().anyMatch(Predicates.catchExceptionAsFalse(f -> f.matches(element, change)));
    }

    @Override
    public boolean matches(Element element, AttributeDifference attributeDifference) {
        for (Filter filter : this.filters) {
            if (!filter.matches(element, attributeDifference)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Element element, String attributeKey) {
        for (Filter filter : this.filters) {
            if (!filter.matches(element, attributeKey)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "CompoundFilter(filters=" + this.getFilters() + ")";
    }

    public List<Filter> getFilters() {
        return this.filters;
    }
}

