/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.ignore.Filters;
import de.retest.recheck.ignore.JSFilterImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;

public interface FilterLoader {
    public Filter load() throws IOException;

    public static FilterLoader loadResource(String path) {
        return () -> {
            try (InputStream stream = FilterLoader.class.getResourceAsStream(path);){
                if (stream == null) {
                    throw new NoSuchFileException(path);
                }
                Filter filter = Filters.parse(Paths.get(path, new String[0]), IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8).stream());
                return filter;
            }
        };
    }

    public static FilterLoader load(Path path) {
        if (path.toString().toLowerCase().endsWith(".filter.js")) {
            return () -> new JSFilterImpl(path);
        }
        return () -> Filters.load(path);
    }

    public static FilterLoader provide(Path path) throws IOException {
        Filter filter = Filters.load(path);
        return () -> filter;
    }
}

