/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.ignore.CompoundFilter;
import de.retest.recheck.ignore.Filter;
import de.retest.recheck.ignore.PersistentFilter;
import de.retest.recheck.review.ignore.io.Loaders;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Filters {
    private Filters() {
    }

    public static Filter load(Path path) throws IOException {
        try (Stream<String> filterFileLines = Files.lines(path);){
            Filter filter = Filters.parse(path, filterFileLines);
            return filter;
        }
    }

    public static Filter parse(String line) {
        return Filters.parse(Stream.of(line));
    }

    public static Filter parse(List<String> lines) {
        return Filters.parse(lines.stream());
    }

    public static Filter parse(Stream<String> lines) {
        return new CompoundFilter(Loaders.filter().load(lines).collect(Collectors.toList()));
    }

    public static Filter parse(Path path, Stream<String> lines) {
        return new CompoundFilter(PersistentFilter.wrap(path, Loaders.filter().load(lines)).collect(Collectors.toList()));
    }
}

