/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSFilterImpl
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(JSFilterImpl.class);
    private static final String JS_ENGINE_NAME = "rhino";
    private final String filePath;
    private final ScriptEngine engine;
    private boolean noMethodWarningPrinted = false;

    public JSFilterImpl(Path filterFilePath) {
        this.filePath = filterFilePath.toString();
        ScriptEngineManager manager = new ScriptEngineManager();
        this.engine = manager.getEngineByName(JS_ENGINE_NAME);
        if (this.engine == null) {
            logger.error("Cannot execute JavaScript rules, `ScriptEngineManager` returned null for engine `JavaScript`. Try switching JDK or add a JavaScript engine: ", (Throwable)new IllegalStateException("No JavaScript available."));
            return;
        }
        try {
            this.engine.eval(this.readScriptFile(filterFilePath));
        }
        catch (Exception e) {
            logger.error("Reading script file '{}' caused exception: ", (Object)filterFilePath, (Object)e);
        }
    }

    Reader readScriptFile(Path filterFilePath) {
        try {
            logger.info("Reading JS filter rules file from '{}'.", (Object)filterFilePath);
            return Files.newBufferedReader(filterFilePath, StandardCharsets.UTF_8);
        }
        catch (NoSuchFileException e) {
            logger.warn("No JS filter file found at '{}': {}", (Object)filterFilePath, (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Error opening JS file from '{}': ", (Object)filterFilePath, (Object)e);
        }
        return new StringReader("");
    }

    @Override
    public boolean matches(Element element) {
        return this.callBooleanJSFunction("matches", element) || this.callBooleanJSFunction("shouldIgnoreElement", element);
    }

    @Override
    public boolean matches(Element element, Filter.ChangeType change) {
        return this.callBooleanJSFunction("matches", element, change.toString().toLowerCase());
    }

    @Override
    public boolean matches(Element element, AttributeDifference attributeDifference) {
        return this.callBooleanJSFunction("matches", element, attributeDifference) || this.callBooleanJSFunction("shouldIgnoreAttributeDifference", element, attributeDifference);
    }

    private boolean callBooleanJSFunction(String functionName, Object ... args) {
        block6: {
            if (this.engine == null) {
                return false;
            }
            Invocable inv = (Invocable)((Object)this.engine);
            try {
                Object callResult = inv.invokeFunction(functionName, args);
                if (callResult == null) {
                    logger.warn("{} returned 'null' instead of a boolean value in file '{}'. Interpreting that as 'false'.", (Object)this.filePath, (Object)functionName);
                    return false;
                }
                if (!(callResult instanceof Boolean)) {
                    logger.error("'{}' of {} cannot be cast to java.lang.Boolean in file '{}'.", new Object[]{callResult, callResult.getClass(), this.filePath});
                    return false;
                }
                return (Boolean)callResult;
            }
            catch (ScriptException e) {
                logger.error("JS '{}' method caused an exception: {} in file '{}'.", new Object[]{functionName, e.getMessage(), this.filePath});
            }
            catch (NoSuchMethodException e) {
                if (functionName.startsWith("shouldIgnore") || this.noMethodWarningPrinted) break block6;
                logger.warn("Specified JS filter file '{}' has no '{}' function.", (Object)this.filePath, (Object)functionName);
                this.noMethodWarningPrinted = true;
            }
        }
        return false;
    }
}

