/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.ignore.Filter;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PersistentFilter
implements Filter {
    private final Path path;
    private final Filter filter;

    public static Stream<PersistentFilter> wrap(Path path, Stream<Filter> filter) {
        return filter.map(f -> new PersistentFilter(path, (Filter)f));
    }

    public static List<Filter> unwrap(List<? extends Filter> input) {
        return input.stream().map(f -> f instanceof PersistentFilter ? ((PersistentFilter)f).getFilter() : f).collect(Collectors.toList());
    }

    @Override
    public boolean matches(Element element) {
        return this.filter.matches(element);
    }

    @Override
    public boolean matches(Element element, Filter.ChangeType change) {
        return this.filter.matches(element, change);
    }

    @Override
    public boolean matches(Element element, String attributeKey) {
        return this.filter.matches(element, attributeKey);
    }

    @Override
    public boolean matches(Element element, AttributeDifference attributeDifference) {
        return this.filter.matches(element, attributeDifference);
    }

    public String toString() {
        return "PersistentFilter(filter=" + this.getFilter() + ")";
    }

    public PersistentFilter(Path path, Filter filter) {
        this.path = path;
        this.filter = filter;
    }

    public Path getPath() {
        return this.path;
    }

    public Filter getFilter() {
        return this.filter;
    }
}

