/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.configuration.ProjectConfigurationUtil;
import de.retest.recheck.review.GlobalIgnoreApplier;
import de.retest.recheck.review.counter.NopCounter;
import de.retest.recheck.review.workers.LoadFilterWorker;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecheckIgnoreLocator {
    private static final Logger log = LoggerFactory.getLogger(RecheckIgnoreLocator.class);
    private final String filename;

    public RecheckIgnoreLocator() {
        this("recheck.ignore");
    }

    public RecheckIgnoreLocator(String filename) {
        this.filename = filename;
    }

    public Optional<Path> getProjectIgnoreFile() {
        Optional<Path> projectConfigurationFolder = ProjectConfigurationUtil.findProjectConfigurationFolder();
        return projectConfigurationFolder.map(p -> p.resolve(this.filename));
    }

    public Path getUserIgnoreFile() {
        return Paths.get(System.getProperty("user.home"), new String[0]).resolve(".retest").resolve(this.filename);
    }

    public Path getSuiteIgnoreFile(Path basePath) {
        return basePath.resolve(this.filename);
    }

    public static GlobalIgnoreApplier loadRecheckIgnore(Path suiteIgnorePath) {
        return RecheckIgnoreLocator.loadRecheckSuiteIgnore(new LoadFilterWorker(NopCounter.getInstance(), suiteIgnorePath));
    }

    private static GlobalIgnoreApplier loadRecheckSuiteIgnore(LoadFilterWorker loadFilterWorker) {
        try {
            return loadFilterWorker.load();
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.debug("Ignoring missing suite or user ignore file.");
        }
        catch (Exception e) {
            log.error("Exception loading suite or user ignore file.", (Throwable)e);
        }
        return GlobalIgnoreApplier.create(NopCounter.getInstance());
    }
}

