/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.configuration.ProjectConfiguration;
import de.retest.recheck.ignore.Filter;
import de.retest.recheck.ignore.FilterLoader;
import de.retest.recheck.ignore.FilterNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchFilterFiles {
    private static final Logger log = LoggerFactory.getLogger(SearchFilterFiles.class);
    public static final String FILTER_EXTENSION = ".filter";
    public static final String FILTER_JS_EXTENSION = ".filter.js";
    public static final String FILTER_DIR_NAME = "filter";
    private static final String WEB_CATEGORY = "web";
    private static final AtomicReference<Object> defaultFilterFiles = new AtomicReference();

    private SearchFilterFiles() {
    }

    public static List<Pair<String, FilterLoader>> getProjectFilterFiles() {
        return ProjectConfiguration.getInstance().getProjectConfigFolder().map(path -> path.resolve(FILTER_DIR_NAME)).map(SearchFilterFiles::loadFiltersFromDirectory).orElse(Collections.emptyList());
    }

    public static List<Pair<String, FilterLoader>> getUserFilterFiles() {
        Path userFilterFolder = Paths.get(System.getProperty("user.home"), ".retest", FILTER_DIR_NAME);
        if (userFilterFolder.toFile().exists()) {
            return SearchFilterFiles.loadFiltersFromDirectory(userFilterFolder);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Pair<String, FilterLoader>> loadFiltersFromDirectory(Path directory) {
        try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);){
            List<Pair<String, FilterLoader>> list = paths.filter(path -> path.toFile().isFile()).filter(SearchFilterFiles::isFilterFile).map(path -> Pair.of((Object)SearchFilterFiles.getFileName(path), (Object)FilterLoader.load(path))).collect(Collectors.toList());
            return list;
        }
        catch (NoSuchFileException e) {
            log.warn("No filter folder found at '{}': {}", (Object)directory, (Object)e.getMessage());
            return Collections.emptyList();
        }
        catch (IOException e) {
            log.error("Exception accessing project filter folder '{}'.", (Object)directory, (Object)e);
        }
        return Collections.emptyList();
    }

    private static boolean isFilterFile(Path path) {
        String fileName = SearchFilterFiles.getFileName(path);
        return fileName.endsWith(FILTER_EXTENSION) || fileName.endsWith(FILTER_JS_EXTENSION);
    }

    public static Map<String, Filter> toFileNameFilterMapping() {
        return SearchFilterFiles.toFileLoaderMapping().entrySet().stream().map(entry -> {
            String name = (String)entry.getKey();
            FilterLoader loader = (FilterLoader)entry.getValue();
            return Pair.of((Object)name, (Object)SearchFilterFiles.loadSilently(loader, name));
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private static Map<String, FilterLoader> toFileLoaderMapping() {
        return Stream.of(SearchFilterFiles.getProjectFilterFiles(), SearchFilterFiles.getUserFilterFiles(), SearchFilterFiles.getDefaultFilterFiles()).flatMap(Collection::stream).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (specificFilterLoader, genericFilterLoader) -> specificFilterLoader));
    }

    private static Filter loadSilently(FilterLoader loader, String name) {
        try {
            return loader.load();
        }
        catch (IOException e) {
            log.error("Could not load filter for name '{}'.", (Object)name, (Object)e);
            return Filter.NEVER_MATCH;
        }
    }

    private static String getFileName(Path path) {
        Path fileName = path.getFileName();
        return fileName != null ? fileName.toString() : "n/a";
    }

    public static Filter getFilterByName(String name) {
        FilterLoader loader = SearchFilterFiles.toFileLoaderMapping().get(name);
        if (loader == null) {
            throw ProjectConfiguration.getInstance().getProjectConfigFolder().map(path -> path.resolve(FILTER_DIR_NAME)).map(Path::toAbsolutePath).map(Path::toString).map(s -> new FilterNotFoundException(name, (String)s)).orElseGet(() -> new FilterNotFoundException(name));
        }
        return SearchFilterFiles.loadSilently(loader, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<String, FilterLoader>> getDefaultFilterFiles() {
        Object value = defaultFilterFiles.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = defaultFilterFiles;
            synchronized (atomicReference) {
                value = defaultFilterFiles.get();
                if (value == null) {
                    List actualValue = Stream.of(FilterResource.prefix(WEB_CATEGORY, "content.filter"), FilterResource.prefix(WEB_CATEGORY, "invisible-attributes.filter"), FilterResource.prefix(WEB_CATEGORY, "positioning.filter"), FilterResource.prefix(WEB_CATEGORY, "style-attributes.filter"), FilterResource.absolute("volatile-metadata.filter"), FilterResource.absolute("metadata.filter")).map(FilterResource::loader).collect(Collectors.toList());
                    value = actualValue == null ? defaultFilterFiles : actualValue;
                    defaultFilterFiles.set(value);
                }
            }
        }
        return (List)(value == defaultFilterFiles ? null : value);
    }

    static final class FilterResource {
        private final String name;
        private final String path;

        static FilterResource absolute(String path) {
            return FilterResource.of(path, "/" + String.join((CharSequence)"/", SearchFilterFiles.FILTER_DIR_NAME, path));
        }

        static FilterResource prefix(String category, String path) {
            return FilterResource.of(path, "/" + String.join((CharSequence)"/", SearchFilterFiles.FILTER_DIR_NAME, category, path));
        }

        public Pair<String, FilterLoader> loader() {
            return Pair.of((Object)this.name, (Object)FilterLoader.loadResource(this.path));
        }

        private FilterResource(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public static FilterResource of(String name, String path) {
            return new FilterResource(name, path);
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterResource)) {
                return false;
            }
            FilterResource other = (FilterResource)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "SearchFilterFiles.FilterResource(name=" + this.getName() + ", path=" + this.getPath() + ")";
        }
    }
}

