/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import de.retest.recheck.RecheckProperties;
import de.retest.recheck.Rehub;
import de.retest.recheck.XmlTransformerUtil;
import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.persistence.Persistence;
import de.retest.recheck.persistence.bin.KryoPersistence;
import de.retest.recheck.persistence.xml.XmlFolderPersistence;
import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.report.TestReport;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPersistence<T extends Persistable>
implements Persistence<T> {
    private static final Logger log = LoggerFactory.getLogger(CloudPersistence.class);
    private static final int MAX_REPORT_NAME_LENGTH = 50;
    private final KryoPersistence<T> kryoPersistence = new KryoPersistence();
    private final XmlFolderPersistence<T> folderPersistence = new XmlFolderPersistence(XmlTransformerUtil.getXmlTransformer());
    public static final String RECHECK_API_KEY = "RECHECK_API_KEY";
    WeakHashMap<TestReport, UUID> reportIdCache = new WeakHashMap();

    @Override
    public void save(URI identifier, T element) throws IOException {
        this.kryoPersistence.save(identifier, element);
        if (this.isAggregatedReport(identifier) && element instanceof TestReport) {
            TestReport report = (TestReport)element;
            try {
                this.saveToCloud(report, Files.readAllBytes(Paths.get(identifier)));
            }
            catch (IOException e) {
                if (!report.containsChanges()) {
                    log.warn("Could not read report '{}' for upload. Ignoring exception because the report does not have any differences.", (Object)identifier, (Object)e);
                }
                log.error("Could not read report '{}' for upload. Rethrowing because report has differences.", (Object)identifier, (Object)e);
                throw e;
            }
        }
    }

    private boolean isAggregatedReport(URI identifier) {
        return identifier.getPath().endsWith("tests.report");
    }

    private List<String> getTestClasses(TestReport report) {
        return report.getSuiteReplayResults().stream().map(SuiteReplayResult::getName).collect(Collectors.toList());
    }

    private void saveToCloud(TestReport report, byte[] data) {
        String uploadUrl = this.getUploadUrlForTestReport(report);
        if (uploadUrl != null) {
            log.trace("Upload URL: {}", (Object)uploadUrl);
            int maxAttempts = RecheckProperties.getInstance().rehubReportUploadAttempts();
            for (int remainingAttempts = maxAttempts - 1; remainingAttempts >= 0; --remainingAttempts) {
                try {
                    this.uploadReport(uploadUrl, data);
                    break;
                }
                catch (UnirestException e) {
                    if (!report.containsChanges()) {
                        log.warn("Failed to upload report. Ignoring exception because the report does not have any differences.", (Throwable)e);
                        break;
                    }
                    if (remainingAttempts == 0) {
                        log.error("Failed to upload report. Aborting, because maximum retries have been reached. If this happens often, consider increasing the property '{}={}'.", new Object[]{"de.retest.recheck.rehub.upload.attempts", maxAttempts, e});
                        throw e;
                    }
                    log.warn("Failed to upload report. Retrying another {} times.", (Object)remainingAttempts, (Object)e);
                    continue;
                }
            }
        } else {
            log.error("Failed to upload report. Aborting, because could not obtain a upload URL.");
        }
    }

    private void uploadReport(String uploadUrl, byte[] data) {
        long start = System.currentTimeMillis();
        HttpResponse uploadResponse = Unirest.put((String)uploadUrl).body(data).asEmpty();
        if (uploadResponse.isSuccess()) {
            long duration = System.currentTimeMillis() - start;
            log.info("Successfully uploaded report to rehub in {} ms", (Object)duration);
        }
    }

    private String getUploadUrlForTestReport(TestReport report) {
        UUID id = this.reportIdCache.computeIfAbsent(report, report2 -> UUID.randomUUID());
        String reportName = String.join((CharSequence)", ", this.getTestClasses(report));
        String token = String.format("Bearer %s", Rehub.getAccessToken());
        HttpResponse uploadUrlResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(RecheckProperties.getInstance().rehubReportUploadUrl() + "/" + id)).queryString("name", (Object)StringUtils.abbreviate((String)reportName, (int)50))).header("Authorization", token)).asString();
        if (uploadUrlResponse.isSuccess()) {
            return (String)uploadUrlResponse.getBody();
        }
        return null;
    }

    @Override
    public T load(URI identifier) throws IOException {
        if (Paths.get(identifier).toFile().isDirectory()) {
            return this.folderPersistence.load(identifier);
        }
        return this.kryoPersistence.load(identifier);
    }
}

