/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitExecutor {
    private static final Logger log = LoggerFactory.getLogger(GitExecutor.class);
    protected static final String GIT_COMMAND_VERSION = "git --version";
    protected static final String GIT_COMMAND_BRANCH_NAME = "git rev-parse --abbrev-ref HEAD";
    protected static final String GIT_COMMAND_COMMIT_HASH = "git rev-parse HEAD";
    protected static final String GIT_COMMAND_STATUS = "git status";
    private final boolean localGit = this.isGitInstalled() && this.isGitUsed();

    public GitExecutor() {
        log.debug("Looks like git is {}used", (Object)(this.localGit ? "" : "not "));
    }

    protected boolean isGitInstalled() {
        try {
            String result = this.executeGitCommand(GIT_COMMAND_VERSION);
            return result != null && result.contains("git version");
        }
        catch (Exception e) {
            log.debug("`{}` resulted in exception {}, assuming no git installed.", (Object)GIT_COMMAND_VERSION, (Object)e.getMessage());
            return false;
        }
    }

    protected boolean isGitUsed() {
        try {
            String result = this.executeGitCommand(GIT_COMMAND_STATUS);
            return result != null && !result.contains("fatal: not a git repository");
        }
        catch (Exception e) {
            log.debug("`{}` resulted in exception {}, assuming no git used.", (Object)GIT_COMMAND_STATUS, (Object)e.getMessage());
            return false;
        }
    }

    /*
     * Loose catch block
     */
    protected String executeGitCommand(String command) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(command);
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                process.waitFor(500L, TimeUnit.MILLISECONDS);
                String string = reader.readLine();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            process.destroy();
        }
    }

    public String getCurrentBranch() {
        return this.executeCommand(GIT_COMMAND_BRANCH_NAME);
    }

    public String getCurrentCommit() {
        return this.executeCommand(GIT_COMMAND_COMMIT_HASH);
    }

    private String executeCommand(String gitCommand) {
        if (this.localGit) {
            try {
                String result = this.executeGitCommand(gitCommand);
                if (result.contains(" ")) {
                    return null;
                }
                return result;
            }
            catch (Exception e) {
                log.error("Exception retrieving Git branch.", (Throwable)e);
            }
        }
        return null;
    }
}

