/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import de.retest.recheck.configuration.ProjectRootFinderUtil;
import de.retest.recheck.persistence.GoldenMasterProvider;
import de.retest.recheck.persistence.NoGoldenMasterFoundException;
import de.retest.recheck.persistence.Persistence;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoldenMasterProviderImpl
implements GoldenMasterProvider {
    public static final String RECHECK_PROJECT_ROOT = "de.retest.recheck.root";
    private static final Logger logger = LoggerFactory.getLogger(GoldenMasterProviderImpl.class);
    private final Persistence<SutState> persistence;

    public GoldenMasterProviderImpl(Persistence<SutState> persistence) {
        this.persistence = persistence;
    }

    @Override
    public File getGoldenMaster(String filePath) throws NoGoldenMasterFoundException {
        return ProjectRootFinderUtil.getProjectRoot().map(projectRoot -> this.getStates((Path)projectRoot, filePath)).map(Path::toFile).orElseThrow(() -> new NoGoldenMasterFoundException(new String[]{filePath}));
    }

    private Path getStates(Path projectRoot, String filePath) {
        if (projectRoot != null && filePath != null) {
            logger.debug("Looking for Golden Master files in '{}'.", (Object)projectRoot);
            Path statePath = Paths.get(projectRoot.toAbsolutePath().toString(), filePath);
            if (statePath.toFile().exists()) {
                return statePath.toAbsolutePath();
            }
        }
        return null;
    }

    @Override
    public SutState loadGoldenMaster(File file) {
        SutState result;
        try {
            result = this.persistence.load(file.toURI());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not load Golden Master from file '" + FileUtil.canonicalPathQuietly(file) + "'.", e);
        }
        if (result == null) {
            throw new NullPointerException("Loaded Golden Master from file '" + FileUtil.canonicalPathQuietly(file) + "' is null.");
        }
        return result;
    }

    @Override
    public void saveGoldenMaster(File file, SutState state) {
        String canonicalPathQuietly = FileUtil.canonicalPathQuietly(file);
        try {
            this.persistence.save(file.toURI(), state);
            logger.info("Updated Golden Master '{}'.", (Object)canonicalPathQuietly);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not apply changes to Golden Master '" + canonicalPathQuietly + "'.", e);
        }
    }
}

