/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import de.retest.recheck.persistence.SeparatePathsProjectLayout;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;

public class GradleProjectLayout
extends SeparatePathsProjectLayout {
    public static final String DEFAULT_RETEST_PROJECT_PATH_FORMAT = "src/%s/resources/retest/";
    public static final String DEFAULT_RETEST_TESTREPORTS_PATH_FORMAT = "build/test-results/%s/retest/";

    public GradleProjectLayout() {
        this("test");
    }

    public GradleProjectLayout(String sourceSetName) {
        super(GradleProjectLayout.toGoldenMasterPath(sourceSetName), GradleProjectLayout.toReportPath(sourceSetName));
    }

    private static Path toReportPath(String sourceSetName) {
        return Paths.get(String.format(DEFAULT_RETEST_TESTREPORTS_PATH_FORMAT, GradleProjectLayout.validate(sourceSetName)), "recheck");
    }

    private static Path toGoldenMasterPath(String sourceSetName) {
        return Paths.get(String.format(DEFAULT_RETEST_PROJECT_PATH_FORMAT, GradleProjectLayout.validate(sourceSetName)), "recheck");
    }

    private static String validate(String sourceSetName) {
        Objects.requireNonNull(sourceSetName, "sourceSetName cannot be null!");
        if (sourceSetName.isEmpty()) {
            throw new IllegalArgumentException("sourceSetName cannot be empty!");
        }
        return sourceSetName;
    }

    @Override
    public Optional<Path> getTestSourcesRoot() {
        return Optional.of(Paths.get("src/test/java", new String[0]));
    }
}

