/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import de.retest.recheck.configuration.ProjectRootFinderUtil;
import de.retest.recheck.persistence.GradleProjectLayout;
import de.retest.recheck.persistence.MavenProjectLayout;
import de.retest.recheck.persistence.ProjectLayout;
import java.nio.file.Path;

public class ProjectLayouts {
    public static final String POM_XML = "pom.xml";
    public static final String BUILD_GRADLE = "build.gradle";

    public static ProjectLayout detect() {
        return ProjectRootFinderUtil.getProjectRoot().map(ProjectLayouts::findProjectBasedOnFiles).orElseThrow(ProjectLayouts::noProjectLayoutFound);
    }

    private static ProjectLayout findProjectBasedOnFiles(Path path) {
        if (ProjectLayouts.exists(path, POM_XML)) {
            return new MavenProjectLayout();
        }
        if (ProjectLayouts.exists(path, BUILD_GRADLE)) {
            return new GradleProjectLayout();
        }
        return null;
    }

    private static boolean exists(Path path, String mavenPomFile) {
        return path.resolve(mavenPomFile).toFile().exists();
    }

    private static IllegalStateException noProjectLayoutFound() {
        return new IllegalStateException("Could not detect project layout. Please specify one explicitly with RecheckOptionsBuilder#projectLayout.");
    }

    private ProjectLayouts() {
    }
}

