/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import de.retest.recheck.SuiteAggregator;
import de.retest.recheck.XmlTransformerUtil;
import de.retest.recheck.persistence.PersistenceFactory;
import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.report.TestReport;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecheckTestReportUtil {
    private static final Logger logger = LoggerFactory.getLogger(RecheckTestReportUtil.class);
    private static final PersistenceFactory persistenceFactory = new PersistenceFactory(XmlTransformerUtil.getXmlTransformer());

    private RecheckTestReportUtil() {
    }

    public static void persist(SuiteReplayResult suite, File file) {
        logger.info("Persisting test report to file '{}'.", (Object)file.getAbsoluteFile().toURI());
        try {
            persistenceFactory.getPersistence().save(file.toURI(), TestReport.fromApi(suite));
            File testReportFile = new File(file.getParent(), "tests.report");
            TestReport aggregatedTestReport = SuiteAggregator.getInstance().getAggregatedTestReport();
            persistenceFactory.getPersistence().save(testReportFile.toURI(), aggregatedTestReport);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not save test report.", e);
        }
    }
}

