/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import de.retest.recheck.persistence.ProjectLayout;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;

public class SeparatePathsProjectLayout
implements ProjectLayout {
    private final Path goldenMasterPath;
    private final Path reportPath;

    public SeparatePathsProjectLayout(Path goldenMasterPath, Path reportPath) {
        this.goldenMasterPath = goldenMasterPath;
        this.reportPath = reportPath;
    }

    @Override
    public Path getGoldenMaster(String suiteName, String testName, String checkName) {
        String fileName = testName + "." + checkName;
        if (StringUtils.isEmpty((CharSequence)testName)) {
            fileName = checkName;
        }
        return this.getSuiteFolder(suiteName).resolve(fileName + ".recheck");
    }

    @Override
    public Path getReport(String suiteName) {
        return this.reportPath.resolve(suiteName + ".report");
    }

    @Override
    public Path getSuiteFolder(String suiteName) {
        return this.goldenMasterPath.resolve(suiteName);
    }
}

