/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.bin;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.objenesis.strategy.InstantiatorStrategy;
import com.esotericsoftware.kryo.kryo5.objenesis.strategy.SerializingInstantiatorStrategy;
import com.esotericsoftware.kryo.kryo5.util.DefaultInstantiatorStrategy;
import de.retest.recheck.persistence.IncompatibleReportVersionException;
import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.persistence.Persistence;
import de.retest.recheck.persistence.bin.KryoRegister;
import de.retest.recheck.report.TestReport;
import de.retest.recheck.util.FileUtil;
import de.retest.recheck.util.VersionProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jpountz.lz4.LZ4FrameInputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoPersistence<T extends Persistable>
implements Persistence<T> {
    private static final Logger log = LoggerFactory.getLogger(KryoPersistence.class);
    private static final String OLD_RECHECK_VERSION = "an old recheck version (pre 1.5.0)";
    private static final Map<Class<?>, Integer> compatibleVersions = KryoPersistence.createCompatibleVersions();
    private final Kryo kryo;
    private final String version;
    private static final Pattern VERSION_CHARS = Pattern.compile("[\\w\\.\\{\\}\\$\\-]+");

    private static Map<Class<?>, Integer> createCompatibleVersions() {
        HashMap map = new HashMap();
        map.put(TestReport.class, 23);
        return map;
    }

    public KryoPersistence() {
        this(KryoPersistence.createKryo(), VersionProvider.RECHECK_VERSION);
    }

    KryoPersistence(Kryo kryo, String version) {
        this.kryo = kryo;
        this.version = version;
    }

    private static Kryo createKryo() {
        Kryo kryo = new Kryo();
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new SerializingInstantiatorStrategy()));
        kryo.setReferences(true);
        KryoRegister.addRecheckClasses(kryo);
        KryoRegister.addUsedJdkClasses(kryo);
        return kryo;
    }

    @Override
    public void save(URI identifier, T element) throws IOException {
        Path path = Paths.get(identifier);
        File file = path.toFile();
        FileUtil.ensureFolder(path.toFile());
        try {
            log.debug("Writing {} to {}. Do not write to same identifier or interrupt until done.", element, (Object)identifier);
            this.save(Files.newOutputStream(path, new OpenOption[0]), element);
            log.debug("Done writing {} to {}", element, (Object)identifier);
        }
        catch (Throwable t) {
            log.error("Error writing to file '{}'. Deleting what has been written to not leave corrupt file behind...", (Object)identifier, (Object)t);
            FileUtils.deleteQuietly((File)file);
            throw t;
        }
    }

    public void save(OutputStream outputStream, T element) throws IOException {
        try (Output output = new Output((OutputStream)new LZ4FrameOutputStream(outputStream));){
            output.writeString(this.version);
            this.kryo.writeClassAndObject(output, element);
        }
    }

    @Override
    public T load(URI identifier) throws IOException {
        Path path = Paths.get(identifier);
        return this.load(Files.newInputStream(path, new OpenOption[0]), identifier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T load(InputStream in, URI identifier) throws IOException {
        String writerVersion = null;
        try (Input input = new Input((InputStream)new LZ4FrameInputStream(in));){
            writerVersion = input.readString();
            Persistable persistable = (Persistable)this.kryo.readClassAndObject(input);
            if (!this.isCompatible(persistable)) {
                throw new IncompatibleReportVersionException(writerVersion, this.version, identifier);
            }
            Persistable persistable2 = persistable;
            return (T)persistable2;
        }
        catch (IncompatibleReportVersionException | NoSuchFileException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.version.equals(writerVersion)) {
                throw e;
            }
            if (KryoPersistence.isKnownFormat(writerVersion)) throw new IncompatibleReportVersionException(writerVersion, this.version, identifier, e);
            writerVersion = OLD_RECHECK_VERSION;
            throw new IncompatibleReportVersionException(writerVersion, this.version, identifier, e);
        }
    }

    private boolean isCompatible(T persistable) {
        return this.isCompatible(persistable.getClass(), ((Persistable)persistable).version());
    }

    boolean isCompatible(Class<? extends Persistable> clazz, int version) {
        Integer minVersion = compatibleVersions.get(clazz);
        return minVersion == null || minVersion <= version;
    }

    protected static boolean isKnownFormat(String writerVersion) {
        if (writerVersion == null) {
            return false;
        }
        Matcher m = VERSION_CHARS.matcher(writerVersion);
        return m.matches();
    }
}

