/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.migration;

import de.retest.recheck.persistence.migration.XmlTransformer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class RemoveElementTransformer
extends XmlTransformer {
    private final String parentElementName;
    private final String elementName;
    private boolean isInParent;
    private boolean isInElement;

    public RemoveElementTransformer(String elementName) {
        this(null, elementName);
    }

    public RemoveElementTransformer(String parentElementName, String elementName) {
        this.parentElementName = parentElementName;
        this.elementName = elementName;
    }

    @Override
    protected void reset() {
        this.isInElement = false;
        this.isInParent = this.parentElementName == null;
    }

    @Override
    public void convert(XMLEvent event, XMLEventWriter eventWriter) throws XMLStreamException {
        if (!this.isInParent && this.isStartElementNamed(event, this.parentElementName)) {
            this.isInParent = true;
            eventWriter.add(event);
            return;
        }
        if (this.isInParent && this.isEndElementNamed(event, this.parentElementName)) {
            this.isInParent = false;
            eventWriter.add(event);
            return;
        }
        if (this.isInParent && this.isStartElementNamed(event, this.elementName)) {
            this.isInElement = true;
            return;
        }
        if (this.isInElement && this.isEndElementNamed(event, this.elementName)) {
            this.isInElement = false;
            return;
        }
        if (this.isInElement) {
            return;
        }
        eventWriter.add(event);
    }
}

