/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.migration;

import de.retest.recheck.util.DeleteOnCloseFileInputStream;
import de.retest.recheck.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlTransformer {
    private static final Logger logger = LoggerFactory.getLogger(XmlTransformer.class);
    private static final String BR = System.getProperty("line.separator");
    protected final XMLEventFactory eventFactory = XMLEventFactory.newInstance();

    public final InputStream transform(InputStream inputStream) {
        try {
            File tmpFile = File.createTempFile("retest-migration-", ".xml.lz4");
            tmpFile.deleteOnExit();
            logger.debug("Creating temporary file '{}' for XML migration. File will be deleted upon exit.", (Object)FileUtil.canonicalPathQuietly(tmpFile));
            this.convertAndWriteToFile(inputStream, tmpFile);
            return new LZ4BlockInputStream((InputStream)new DeleteOnCloseFileInputStream(tmpFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void convertAndWriteToFile(InputStream inputStream, File tmpFile) throws IOException {
        try (LZ4BlockOutputStream out = new LZ4BlockOutputStream((OutputStream)new FileOutputStream(tmpFile));){
            this.reset();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLEventReader eventReader = inputFactory.createXMLEventReader(inputStream, StandardCharsets.UTF_8.name());
            XMLEventWriter eventWriter = XMLOutputFactory.newInstance().createXMLEventWriter((OutputStream)out, StandardCharsets.UTF_8.name());
            while (eventReader.hasNext()) {
                XMLEvent nextEvent = eventReader.nextEvent();
                this.convert(nextEvent, eventWriter);
            }
            eventReader.close();
            eventWriter.flush();
            eventWriter.close();
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void reset();

    public abstract void convert(XMLEvent var1, XMLEventWriter var2) throws XMLStreamException;

    protected Characters newline() {
        return this.eventFactory.createCharacters(BR);
    }

    protected boolean isStartElementNamed(XMLEvent event, String tagname) {
        return event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(tagname);
    }

    protected boolean hasAttribute(XMLEvent event, String key, String value) {
        Attribute attribute = event.asStartElement().getAttributeByName(new QName(key));
        return attribute != null && attribute.getValue().equals(value);
    }

    protected boolean isEndElementNamed(XMLEvent event, String tagname) {
        return event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(tagname);
    }

    protected StartElement startElementNamed(String tagname) {
        return this.eventFactory.createStartElement(new QName(tagname), null, null);
    }

    protected StartElement startElementNamed(String tagname, Iterator<? extends Attribute> attributes) {
        return this.eventFactory.createStartElement(new QName(tagname), attributes, null);
    }

    protected XMLEvent startElementNamed(String tagname, Attribute ... attributes) {
        return this.startElementNamed(tagname, Arrays.asList(attributes).iterator());
    }

    protected Attribute attribute(String attributeName, String value) {
        return this.eventFactory.createAttribute(new QName(attributeName), value);
    }

    protected EndElement endElementNamed(String tagname) {
        return this.eventFactory.createEndElement(new QName(tagname), null);
    }

    protected Characters characters(String contents) {
        return this.eventFactory.createCharacters(contents);
    }
}

