/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.migration.transformers;

import de.retest.recheck.persistence.migration.XmlTransformer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;

public class WindowSuffixTransformer
extends XmlTransformer {
    private boolean isInPath;
    private boolean isWindowPath;
    private boolean isInWindowSuffix;
    private final String tagname = "attribute";

    @Override
    protected void reset() {
        this.isInPath = false;
        this.isWindowPath = false;
        this.isInWindowSuffix = false;
    }

    @Override
    public void convert(XMLEvent event, XMLEventWriter eventWriter) throws XMLStreamException {
        if (this.updatePath(event)) {
            eventWriter.add(event);
            return;
        }
        if (this.updatePath(event, eventWriter) || this.updateWindowsSuffix(event, eventWriter)) {
            return;
        }
        eventWriter.add(event);
    }

    protected boolean updatePath(XMLEvent event, XMLEventWriter eventWriter) throws XMLStreamException {
        if (this.isInPath && event.isCharacters()) {
            Characters characters = event.asCharacters();
            String window = characters.getData();
            this.isWindowPath = "Window".equals(window);
            String replace = window.replaceFirst("Window", "Window_0");
            eventWriter.add(this.characters(replace));
            return true;
        }
        return false;
    }

    private boolean updatePath(XMLEvent event) {
        if (this.isStartElementNamed(event, "attribute") && this.hasAttribute(event, "key", "path")) {
            this.isInPath = true;
            return true;
        }
        if (this.isInPath && this.isEndElementNamed(event, "attribute")) {
            this.isInPath = false;
            return true;
        }
        return false;
    }

    private boolean updateWindowsSuffix(XMLEvent event, XMLEventWriter eventWriter) throws XMLStreamException {
        if (this.isWindowPath && this.isStartElementNamed(event, "attribute") && this.hasAttribute(event, "key", "suffix")) {
            this.isInWindowSuffix = true;
            eventWriter.add(event);
            eventWriter.add(this.characters("0"));
            return true;
        }
        if (this.isInWindowSuffix && this.isEndElementNamed(event, "attribute")) {
            this.isInWindowSuffix = false;
            eventWriter.add(event);
            return true;
        }
        return false;
    }
}

