/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.xml;

import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.persistence.Persistence;
import de.retest.recheck.persistence.xml.ReTestXmlDataContainer;
import de.retest.recheck.persistence.xml.XmlPersistenceUtil;
import de.retest.recheck.persistence.xml.XmlTransformer;
import de.retest.recheck.persistence.xml.util.ScreenshotFolderPersistence;
import de.retest.recheck.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlFolderPersistence<T extends Persistable>
implements Persistence<T> {
    private static final Logger logger = LoggerFactory.getLogger(XmlFolderPersistence.class);
    private final XmlTransformer xmlTransformer;
    private final String xmlFileName;

    public XmlFolderPersistence(XmlTransformer xmlTransformer) {
        this.xmlTransformer = xmlTransformer;
        this.xmlFileName = "retest.xml";
    }

    public XmlFolderPersistence(XmlTransformer xmlTransformer, String xmlFileName) {
        this.xmlTransformer = xmlTransformer;
        this.xmlFileName = xmlFileName;
    }

    @Override
    public void save(URI identifier, T element) throws IOException {
        File baseFolder = new File(identifier);
        ReTestXmlDataContainer<T> container = new ReTestXmlDataContainer<T>(element);
        if (!baseFolder.exists()) {
            logger.debug("baseFolder '{}' don't exists, create new one", (Object)baseFolder);
            baseFolder.mkdirs();
        }
        ScreenshotFolderPersistence screenshotPersistence = new ScreenshotFolderPersistence(baseFolder);
        File xmlFile = new File(baseFolder, this.xmlFileName);
        FileUtil.writeToFile(xmlFile, out -> this.xmlTransformer.toXML(container, out, screenshotPersistence.getMarshallListener()));
    }

    @Override
    public T load(URI identifier) throws IOException {
        File baseFolder = new File(identifier);
        File xmlFile = new File(baseFolder, this.xmlFileName);
        ScreenshotFolderPersistence screenshotPersistence = new ScreenshotFolderPersistence(baseFolder);
        ReTestXmlDataContainer container = FileUtil.readFromFile(xmlFile, in -> XmlPersistenceUtil.migrateAndRead(this.xmlTransformer, in, screenshotPersistence.getUnmarshallListener()));
        if (container == null) {
            return null;
        }
        return container.data();
    }

    public String getXmlFileName() {
        return this.xmlFileName;
    }
}

