/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.xml;

import com.google.common.collect.ImmutableMap;
import de.retest.recheck.persistence.xml.XmlTransformerConfiguration;
import de.retest.recheck.persistence.xml.util.SessionLogDelegate;
import de.retest.recheck.persistence.xml.util.StdXmlClassesProvider;
import de.retest.recheck.persistence.xml.util.XmlUtil;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.persistence.internal.oxm.record.namespaces.MapNamespacePrefixMapper;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlTransformer {
    private static final Logger log = LoggerFactory.getLogger(XmlTransformer.class);
    private static final ImmutableMap<String, String> NAMESPACE_MAPPINGS = ImmutableMap.of((Object)"http://www.w3.org/2001/XMLSchema", (Object)"xsd", (Object)"http://www.w3.org/2001/XMLSchema-instance", (Object)"xsi");
    private static final Set<Marshaller> lightweightMarshallerSet = new HashSet<Marshaller>();
    private final XmlTransformerConfiguration config;
    private final Class<?>[] additionalClazzes;

    public static boolean isLightweightMarshaller(Marshaller m) {
        return lightweightMarshallerSet.contains(m);
    }

    public XmlTransformer(XmlTransformerConfiguration config, Class<?> ... additionalClazzes) {
        this.config = config;
        this.additionalClazzes = additionalClazzes;
    }

    public XmlTransformer(Class<?> ... additionalClazzes) {
        this(XmlTransformerConfiguration.builder().build(), additionalClazzes);
    }

    public XmlTransformer(Set<Class<?>> xmlDataClasses) {
        this(xmlDataClasses.toArray(new Class[xmlDataClasses.size()]));
    }

    public <T> T fromXML(InputStream in) {
        return this.fromXML(in, null);
    }

    public <T> T fromXML(InputStream in, Unmarshaller.Listener listener) {
        try {
            JAXBContext jc = this.createJAXBContext(this.additionalClazzes);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            unmarshaller.setListener(listener);
            Object result = unmarshaller.unmarshal(in);
            return (T)result;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public void toXML(Object obj, OutputStream out, Marshaller.Listener listener) {
        Marshaller marshaller = null;
        try {
            JAXBContext jc = this.createJAXBContext(this.additionalClazzes);
            marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("eclipselink.namespace-prefix-mapper", (Object)new MapNamespacePrefixMapper(NAMESPACE_MAPPINGS));
            marshaller.setProperty("eclipselink.indent-string", (Object)"\t");
            marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            marshaller.setListener(listener);
            SessionLogDelegate sessionLog = new SessionLogDelegate(AbstractSessionLog.getLog());
            AbstractSessionLog.setLog((SessionLog)sessionLog);
            if (this.config.isOnlyFragment()) {
                log.info("Create only fragment for '{}'.", obj);
                marshaller.setProperty("jaxb.fragment", (Object)true);
            }
            if (this.config.isLightweightXml()) {
                log.info("Use lightweight XML for '{}'.", obj);
                lightweightMarshallerSet.add(marshaller);
                XmlUtil.addLightWeightAdapter(marshaller);
            }
            marshaller.marshal(obj, out);
            if (sessionLog.containsMessages()) {
                throw new RuntimeException("Error persisting XML: " + sessionLog.getLog());
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.config.isLightweightXml() && marshaller != null) {
                lightweightMarshallerSet.remove(marshaller);
            }
        }
    }

    public void toXML(Object obj, OutputStream out) {
        this.toXML(obj, out, null);
    }

    public String toXML(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.toXML(obj, ps);
        return baos.toString();
    }

    private JAXBContext createJAXBContext(Class<?> ... additionalClazzes) {
        try {
            Class[] contextClasses = StdXmlClassesProvider.getXmlDataClasses(additionalClazzes);
            return JAXBContextFactory.createContext((Class[])contextClasses, Collections.emptyMap());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

