/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.xml;

import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.persistence.Persistence;
import de.retest.recheck.persistence.xml.ReTestXmlDataContainer;
import de.retest.recheck.persistence.xml.XmlPersistenceUtil;
import de.retest.recheck.persistence.xml.XmlTransformer;
import de.retest.recheck.persistence.xml.util.LazyScreenshotZipPersistence;
import de.retest.recheck.util.FileUtil;
import de.retest.recheck.util.NamedBufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlZipPersistence<T extends Persistable>
implements Persistence<T> {
    private static final Logger logger = LoggerFactory.getLogger(XmlZipPersistence.class);
    private static final int COMPRESSION_LEVEL = 9;
    private final XmlTransformer xml;

    public XmlZipPersistence(XmlTransformer xml) {
        this.xml = xml;
    }

    @Override
    public void save(URI identifier, T element) throws IOException {
        File file = new File(identifier);
        ReTestXmlDataContainer<T> container = new ReTestXmlDataContainer<T>(element);
        LazyScreenshotZipPersistence screenshotPersistence = new LazyScreenshotZipPersistence();
        if (file.isDirectory()) {
            FileUtils.deleteDirectory((File)file);
        }
        FileUtil.ensureFolder(file);
        FileUtil.writeToFile(file, out -> {
            ZipOutputStream zout = new ZipOutputStream(out);
            zout.setLevel(9);
            zout.putNextEntry(new ZipEntry("retest.xml"));
            this.xml.toXML(container, zout, screenshotPersistence.getMarshallListener());
            logger.debug("XML saved, now saving screenshots...");
            screenshotPersistence.saveScreenshotsNow(zout);
            logger.debug("Save to '{}' completed.", (Object)identifier);
            zout.close();
        });
    }

    @Override
    public T load(URI identifier) throws IOException {
        File file = new File(identifier);
        LazyScreenshotZipPersistence screenshotPersistence = new LazyScreenshotZipPersistence();
        ReTestXmlDataContainer container = FileUtil.readFromZipFile(file, zipFile -> {
            ReTestXmlDataContainer result = XmlPersistenceUtil.migrateAndRead(this.xml, this.getReTestXmlInStream(zipFile), screenshotPersistence.getUnmarshallListener());
            logger.debug("XML loaded from file '{}', now loading screenshots.", (Object)identifier);
            screenshotPersistence.loadScreenshotsNow(zipFile);
            return result;
        });
        if (container == null) {
            return null;
        }
        return container.data();
    }

    NamedBufferedInputStream getReTestXmlInStream(ZipFile zipFile) throws IOException {
        ZipEntry entry = zipFile.getEntry("retest.xml");
        if (entry == null) {
            throw new IllegalArgumentException("Given ZIP file " + zipFile.getName() + " did not contain an entry named " + "retest.xml" + "!");
        }
        return new NamedBufferedInputStream(zipFile.getInputStream(entry), zipFile.getName());
    }
}

