/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.xml.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.util.ReflectionUtilities;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyScreenshotZipPersistence {
    private static final Logger logger = LoggerFactory.getLogger(LazyScreenshotZipPersistence.class);
    final List<Screenshot> screenshots = new CopyOnWriteArrayList<Screenshot>();
    final Multimap<Screenshot, Object> screenshotParentMap = ArrayListMultimap.create();

    public Marshaller.Listener getMarshallListener() {
        return new Marshaller.Listener(){

            public void afterMarshal(Object source) {
                if (source instanceof Screenshot) {
                    LazyScreenshotZipPersistence.this.screenshots.add((Screenshot)source);
                }
            }
        };
    }

    public void saveScreenshotsNow(ZipOutputStream zout) {
        ArrayList<String> beforePersistedIds = new ArrayList<String>();
        for (Screenshot screenshot : this.screenshots) {
            if (beforePersistedIds.contains(screenshot.getPersistenceId())) {
                logger.debug("Image already persisted (duplicate): {}", (Object)screenshot.getPersistenceId());
                continue;
            }
            this.saveScreenshot(zout, screenshot);
            beforePersistedIds.add(screenshot.getPersistenceId());
        }
    }

    private void saveScreenshot(ZipOutputStream zout, Screenshot screenshot) {
        if (screenshot.getBinaryData() != null) {
            try {
                zout.putNextEntry(new ZipEntry(LazyScreenshotZipPersistence.createFilePath(screenshot)));
                zout.write(screenshot.getBinaryData());
            }
            catch (IOException e) {
                logger.error("Error writing entry {} to zip file: {}.", (Object)screenshot, (Object)e.getMessage());
            }
        } else {
            logger.warn("Found screenshot without data! {}", (Object)screenshot);
        }
    }

    public Unmarshaller.Listener getUnmarshallListener() {
        return new Unmarshaller.Listener(){

            public void afterUnmarshal(Object target, Object parent) {
                if (target instanceof Screenshot) {
                    LazyScreenshotZipPersistence.this.screenshots.add((Screenshot)target);
                    LazyScreenshotZipPersistence.this.screenshotParentMap.put((Object)((Screenshot)target), parent);
                }
            }
        };
    }

    public void loadScreenshotsNow(ZipFile zipFile) throws IOException {
        for (Screenshot screenshot : this.screenshots) {
            String path = LazyScreenshotZipPersistence.createFilePath(screenshot);
            try {
                ZipEntry entry = zipFile.getEntry(path);
                InputStream in = zipFile.getInputStream(entry);
                screenshot.setBinaryData(IOUtils.toByteArray((InputStream)in));
            }
            catch (Exception exc) {
                logger.warn("Could not load screenshot '{}' from {}.", (Object)path, (Object)zipFile.getName());
                for (Object parent : this.screenshotParentMap.get((Object)screenshot)) {
                    ReflectionUtilities.setChildInParentToNull(parent, screenshot);
                }
            }
        }
    }

    protected static String createFilePath(Screenshot screenshot) {
        return "screenshot/" + new File(screenshot.getPersistenceId()).getName() + "." + screenshot.getType().getFileExtension();
    }
}

