/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.xml.util;

import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.util.FileUtil;
import de.retest.recheck.util.NamedBufferedInputStream;
import de.retest.recheck.util.ReflectionUtilities;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class ScreenshotFolderPersistence {
    private final File screenshotFolder;
    boolean prepared;
    private final Map<Object, Screenshot> parentsWithIncorrectScreenshots = new HashMap<Object, Screenshot>();

    public ScreenshotFolderPersistence(File baseFolder) {
        this.screenshotFolder = new File(baseFolder, "screenshot");
        this.prepared = false;
    }

    private void prepare() {
        if (!this.screenshotFolder.exists()) {
            this.screenshotFolder.mkdir();
        }
        this.prepared = true;
    }

    protected static String createFileName(Screenshot screenshot) {
        return new File(screenshot.getPersistenceId()).getName() + "." + screenshot.getType().getFileExtension();
    }

    public Marshaller.Listener getMarshallListener() {
        return new Marshaller.Listener(){

            public void afterMarshal(Object source) {
                if (source instanceof Screenshot) {
                    if (!ScreenshotFolderPersistence.this.prepared) {
                        ScreenshotFolderPersistence.this.prepare();
                    }
                    ScreenshotFolderPersistence.this.saveScreenshot((Screenshot)source);
                }
            }
        };
    }

    private void saveScreenshot(Screenshot screenshot) {
        File file = new File(this.screenshotFolder, ScreenshotFolderPersistence.createFileName(screenshot));
        FileUtil.tryWriteToFile(file, out -> out.write(screenshot.getBinaryData()));
    }

    public Unmarshaller.Listener getUnmarshallListener() {
        return new Unmarshaller.Listener(){

            public void afterUnmarshal(Object target, Object parent) {
                if (target instanceof Screenshot) {
                    if (!ScreenshotFolderPersistence.this.loadScreenshot((Screenshot)target)) {
                        ScreenshotFolderPersistence.this.parentsWithIncorrectScreenshots.put(parent, (Screenshot)target);
                    }
                } else if (ScreenshotFolderPersistence.this.parentsWithIncorrectScreenshots.containsKey(target)) {
                    ReflectionUtilities.setChildInParentToNull(target, ScreenshotFolderPersistence.this.parentsWithIncorrectScreenshots.get(target));
                }
            }
        };
    }

    private boolean loadScreenshot(Screenshot screenshot) {
        File file = new File(this.screenshotFolder, ScreenshotFolderPersistence.createFileName(screenshot));
        byte[] binaryData = FileUtil.tryReadFromFile(file, new ToByteArrayReader());
        screenshot.setBinaryData(binaryData);
        return binaryData != null;
    }

    private static final class ToByteArrayReader
    implements FileUtil.Reader<byte[]> {
        private ToByteArrayReader() {
        }

        @Override
        public byte[] read(NamedBufferedInputStream in) throws IOException {
            return IOUtils.toByteArray((InputStream)in);
        }
    }
}

