/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.printer;

import de.retest.recheck.NoGoldenMasterActionReplayResult;
import de.retest.recheck.printer.ElementDifferencePrinter;
import de.retest.recheck.printer.MetadataDifferencePrinter;
import de.retest.recheck.printer.Printer;
import de.retest.recheck.printer.highlighting.DefaultHighlighter;
import de.retest.recheck.printer.highlighting.Highlighter;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.RootElementDifference;
import de.retest.recheck.ui.diff.StateDifference;
import de.retest.recheck.ui.diff.meta.MetadataDifference;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ActionReplayResultPrinter
implements Printer<ActionReplayResult> {
    private final ElementDifferencePrinter printer;
    private final MetadataDifferencePrinter metadataDifferencePrinter;

    public ActionReplayResultPrinter(DefaultValueFinder defaultValueFinder) {
        this(defaultValueFinder, new DefaultHighlighter());
    }

    public ActionReplayResultPrinter(DefaultValueFinder defaultValueFinder, Highlighter highlighter) {
        this.printer = new ElementDifferencePrinter(defaultValueFinder, highlighter);
        this.metadataDifferencePrinter = new MetadataDifferencePrinter(highlighter);
    }

    @Override
    public String toString(ActionReplayResult difference, String indent) {
        boolean hasMetadataDifferences;
        String prefix = indent + this.createDescription(difference) + "\n";
        String nextIndent = indent + "\t";
        if (difference instanceof NoGoldenMasterActionReplayResult) {
            return prefix + nextIndent + "No Golden Master found. First time test was run? Created new Golden Master, so don't forget to commit...";
        }
        StateDifference stateDifference = difference.getStateDifference();
        boolean hasStateDifferences = difference.hasDifferences();
        MetadataDifference metadataDifference = difference.getMetadataDifference();
        boolean bl = hasMetadataDifferences = !metadataDifference.isEmpty();
        if (!hasMetadataDifferences && hasStateDifferences) {
            return prefix + this.createStateDifferences(stateDifference, nextIndent);
        }
        if (hasMetadataDifferences && !hasStateDifferences) {
            return prefix + this.createMetadataDifferences(metadataDifference, nextIndent);
        }
        return prefix + this.createMetadataDifferences(metadataDifference, nextIndent) + "\n" + this.createStateDifferences(stateDifference, nextIndent);
    }

    private String createDescription(ActionReplayResult difference) {
        return difference.getDescription() + " resulted in:";
    }

    private String createMetadataDifferences(MetadataDifference difference, String indent) {
        return this.metadataDifferencePrinter.toString(difference, indent);
    }

    private String createStateDifferences(StateDifference difference, String indent) {
        return difference.getRootElementDifferences().stream().map(RootElementDifference::getElementDifference).flatMap(this::getDifference).filter(ElementDifference::hasAnyDifference).map(diff -> this.printer.toString((ElementDifference)diff, indent)).collect(Collectors.joining("\n"));
    }

    private Stream<ElementDifference> getDifference(ElementDifference origin) {
        if (origin.isInsertionOrDeletion()) {
            return Stream.of(origin);
        }
        return Stream.concat(Stream.of(origin), origin.getChildDifferences().stream().flatMap(this::getDifference));
    }
}

