/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.printer;

import de.retest.recheck.printer.Printer;
import de.retest.recheck.printer.highlighting.DefaultHighlighter;
import de.retest.recheck.printer.highlighting.HighlightType;
import de.retest.recheck.printer.highlighting.Highlighter;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.ElementIdentificationWarning;
import java.util.List;
import java.util.stream.Collectors;

public class AttributeDifferencePrinter
implements Printer<AttributeDifference> {
    private static final String IS_DEFAULT = "(default or absent)";
    private static final String WARNING_FILENAME_LINE_FORMAT = ", breaks=\"%s\"";
    private final IdentifyingAttributes attributes;
    private final DefaultValueFinder defaultProvider;
    private final Highlighter highlighter;

    public AttributeDifferencePrinter(IdentifyingAttributes attributes, DefaultValueFinder defaultProvider) {
        this(attributes, defaultProvider, new DefaultHighlighter());
    }

    public AttributeDifferencePrinter(IdentifyingAttributes attributes, DefaultValueFinder defaultProvider, Highlighter highlighter) {
        this.attributes = attributes;
        this.defaultProvider = defaultProvider;
        this.highlighter = highlighter;
    }

    @Override
    public String toString(AttributeDifference difference, String indent) {
        if (difference.hasElementIdentificationWarning()) {
            return indent + this.format(difference) + this.printWarning(difference);
        }
        return indent + this.format(difference);
    }

    private String format(AttributeDifference difference) {
        if (this.isExpectedDefault(difference)) {
            return this.printExpectedDefaultDifference(difference);
        }
        if (this.isActualDefault(difference)) {
            return this.printActualDefaultDifference(difference);
        }
        return this.printBothDifferences(difference);
    }

    private boolean isActualDefault(AttributeDifference difference) {
        return this.defaultProvider.isDefaultValue(this.attributes, difference.getKey(), difference.getActual());
    }

    private String printActualDefaultDifference(AttributeDifference difference) {
        String key = this.highlighter.highlight(difference.getKey(), HighlightType.KEY);
        String expected = this.highlighter.highlight(difference.getExpectedToString(), HighlightType.VALUE_EXPECTED);
        String keyExpectedActualFormat = this.getKeyExpectedActualFormat();
        return String.format(keyExpectedActualFormat, key, expected, IS_DEFAULT);
    }

    private boolean isExpectedDefault(AttributeDifference difference) {
        return difference.getExpected() == null;
    }

    private String printExpectedDefaultDifference(AttributeDifference difference) {
        String key = this.highlighter.highlight(difference.getKey(), HighlightType.KEY);
        String actual = this.highlighter.highlight(difference.getActualToString(), HighlightType.VALUE_ACTUAL);
        String keyExpectedActualFormat = this.getKeyExpectedActualFormat();
        return String.format(keyExpectedActualFormat, key, IS_DEFAULT, actual);
    }

    private String printBothDifferences(AttributeDifference difference) {
        String key = this.highlighter.highlight(difference.getKey(), HighlightType.KEY);
        String expected = this.highlighter.highlight(difference.getExpectedToString(), HighlightType.VALUE_EXPECTED);
        String actual = this.highlighter.highlight(difference.getActualToString(), HighlightType.VALUE_ACTUAL);
        String keyExpectedActualFormat = this.getKeyExpectedActualFormat();
        return String.format(keyExpectedActualFormat, key, expected, actual);
    }

    private String printWarning(AttributeDifference difference) {
        List<ElementIdentificationWarning> warnings = difference.getElementIdentificationWarnings();
        return String.format(WARNING_FILENAME_LINE_FORMAT, warnings.stream().map(this::formatWarning).collect(Collectors.joining(", ")));
    }

    private String formatWarning(ElementIdentificationWarning warning) {
        return warning.getTestFileName() + ":" + warning.getTestLineNumber();
    }

    private String getKeyExpectedActualFormat() {
        String expected = this.highlighter.highlight("expected", HighlightType.EXPECTED);
        String actual = this.highlighter.highlight("actual", HighlightType.ACTUAL);
        return "%s: " + expected + "=\"%s\", " + actual + "=\"%s\"";
    }
}

