/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.printer;

import de.retest.recheck.printer.AttributeDifferencePrinter;
import de.retest.recheck.printer.InsertedDeletedElementDifferencePrinter;
import de.retest.recheck.printer.Printer;
import de.retest.recheck.printer.highlighting.DefaultHighlighter;
import de.retest.recheck.printer.highlighting.HighlightType;
import de.retest.recheck.printer.highlighting.Highlighter;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.InsertedDeletedElementDifference;
import de.retest.recheck.ui.diff.LeafDifference;
import java.util.stream.Collectors;

public class ElementDifferencePrinter
implements Printer<ElementDifference> {
    private final DefaultValueFinder finder;
    private final Highlighter highlighter;

    public ElementDifferencePrinter(DefaultValueFinder finder) {
        this(finder, new DefaultHighlighter());
    }

    public ElementDifferencePrinter(DefaultValueFinder finder, Highlighter highlighter) {
        this.finder = finder;
        this.highlighter = highlighter;
    }

    @Override
    public String toString(ElementDifference difference, String indent) {
        return indent + this.createDescription(difference) + "\n" + this.createDifferences(difference, indent + "\t");
    }

    private String createDescription(ElementDifference difference) {
        IdentifyingAttributes attributes = difference.getIdentifyingAttributes();
        String type = this.highlighter.highlight(attributes.getType(), HighlightType.TYPE);
        String path = this.highlighter.highlight(attributes.getPath(), HighlightType.PATH);
        String element = this.highlighter.highlight(difference.getElementToString(), HighlightType.ELEMENT);
        return type + " (" + element + ") at '" + path + "':";
    }

    private String createDifferences(ElementDifference difference, String indent) {
        LeafDifference identifyingAttributesDifference = difference.getIdentifyingAttributesDifference();
        if (identifyingAttributesDifference instanceof InsertedDeletedElementDifference) {
            InsertedDeletedElementDifferencePrinter printer = new InsertedDeletedElementDifferencePrinter();
            return printer.toString((InsertedDeletedElementDifference)identifyingAttributesDifference, indent);
        }
        IdentifyingAttributes attributes = difference.getIdentifyingAttributes();
        AttributeDifferencePrinter delegate = new AttributeDifferencePrinter(attributes, this.finder, this.highlighter);
        return difference.getAttributeDifferences().stream().map(d -> delegate.toString((AttributeDifference)d, indent)).collect(Collectors.joining("\n"));
    }
}

