/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.printer;

import de.retest.recheck.printer.Printer;
import de.retest.recheck.printer.highlighting.DefaultHighlighter;
import de.retest.recheck.printer.highlighting.HighlightType;
import de.retest.recheck.printer.highlighting.Highlighter;
import de.retest.recheck.ui.diff.meta.MetadataDifference;
import de.retest.recheck.ui.diff.meta.MetadataElementDifference;
import java.util.stream.Collectors;

public class MetadataDifferencePrinter
implements Printer<MetadataDifference> {
    private final Highlighter highlighter;

    public MetadataDifferencePrinter() {
        this(new DefaultHighlighter());
    }

    public MetadataDifferencePrinter(Highlighter highlighter) {
        this.highlighter = highlighter;
    }

    @Override
    public String toString(MetadataDifference difference, String indent) {
        String prefix = this.highlighter.highlight("Metadata Differences:\n", HighlightType.HEADING_METADATA);
        String note = this.highlighter.highlight("Please note that these differences do not affect the result and are not included in the difference count.", HighlightType.NOTE);
        String noteIndent = indent + "  ";
        String differenceIndent = indent + "\t";
        return indent + prefix + noteIndent + note + this.printDifferences(difference, differenceIndent);
    }

    private String printDifferences(MetadataDifference difference, String indent) {
        return difference.getDifferences().stream().map(this::print).collect(Collectors.joining("\n" + indent, "\n" + indent, ""));
    }

    private String print(MetadataElementDifference difference) {
        String keyExpectedActualFormat = "%s: expected=\"%s\", actual=\"%s\"";
        return String.format("%s: expected=\"%s\", actual=\"%s\"", difference.getKey(), difference.getExpected(), difference.getActual());
    }
}

